package jp.ill.photon.module.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ActionUtil;
import jp.ill.photon.util.JsonUtil;

import org.apache.commons.collections.CollectionUtils;

/**
 * リクエストからJSON文字列を生成するモジュール
 *
 * @author m_fukukawa
 *
 */
public class CreateJsonModule implements PhotonModule {

	/* 配列の項目名 */
	@ModuleParam(required=false)
	private String[] arrayItemName;

	@Override
	public ModuleResult execute(ModuleContext context) {

		ActionDto dto = context.getDto();

		Map<String, Object> request = dto.getRawParams();
		Map<String, Object> json = new HashMap<String, Object>();
		List<String> arrItemNameList = (arrayItemName != null)? Arrays.asList(arrayItemName) : null;
		for (Map.Entry<String, Object> e : request.entrySet()) {
			Object value = null;
			if (e.getKey() != null) {
				if (!CollectionUtils.isEmpty(arrItemNameList) && arrItemNameList.contains(e.getKey())) {
					//value = ActionUtil.getActionParams(request, e.getKey());
					Object[] val = (Object[]) ActionUtil.getActionParams(request, e.getKey());
					List<Object> list = new ArrayList<Object>();
					for (int i = 0; i < val.length; i++) {
						String item = (String)val[i];
						Object out = null;
						if (JsonUtil.isAbleToConverToMap(item)) {
							out = JsonUtil.jsonToMap(item);
						} else {
							out = val[i];
						}
						list.add(out);
					}
					value = list;
				} else {
					value = ActionUtil.getActionParamString(request, e.getKey(), ", ");
				}
			}
			json.put(e.getKey(), value);
		}
		String jsonStr = JsonUtil.mapToJson(json);

		ModuleResult result = new ModuleResult();
		// フォームデータのセット
		result.getReturnData().put("json", json);
		result.getReturnData().put("json_str", jsonStr);

		return result;
	}

	/**
	 * arrayItemNameを取得します。
	 * @return arrayItemName
	 */

	public String[] getArrayItemName() {
		return arrayItemName;
	}

	/**
	 * arrayItemNameを設定します。
	 * @param arrayItemName
	 */

	public void setArrayItemName(String[] arrayItemName) {
		this.arrayItemName = arrayItemName;
	}

}
