package jp.ill.photon.module.common;

import java.util.List;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.StringUtil;

/**
 * [text2list] 特定の文字で区切られた文字列をリストにしてDTOに格納するモジュール.
 *
 * <p>
 * <h2>DTOへの設定値：</h2>
 * <dl>
 * <dt>list</dt>
 * <dd>分割結果のリスト（List&lt;String&gt;）</dd>
 * <dt>first</dt>
 * <dd>分割結果の最初の値（String型）</dd>
 * </dl>
 * </p>
 * 
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class Text2ListModule implements PhotonModule {

	/**
	 * 区切り文字指定用モジュールパラメータ.
	 * 
	 * <p>
	 * 指定されなかった場合、","が使用される。
	 * </p>
	 */
	@ModuleParam(required = false)
	private String separator;

	/**
	 * 分割対象テキスト用モジュールパラメータ.
	 */
	@ModuleParam(required = true)
	private String srcText;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = new ModuleResult();

		List<String> list = StringUtil.csvTextToList(getSeparator(),
				getSrcText());

		if (list != null && list.size() >= 1) {
			result.getReturnData().put("first", list.get(0));
		}

		result.getReturnData().put("list", list);

		return result;
	}

	public String getSeparator() {
		if (separator == null) {
			separator = ",";
		}
		return separator;
	}

	public void setSeparator(String separator) {
		this.separator = separator;
	}

	public String getSrcText() {
		return srcText;
	}

	public void setSrcText(String srcText) {
		this.srcText = srcText;
	}

}
