package jp.ill.photon.module.common;

import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * 文字列パラメータが空かどうか判断するモジュール 返却するReturnDataの値も指定できる。
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class StringIsEmptyModule implements PhotonModule {

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "static", transferVal = "is_empty")
	private String isEmptyRetCode;

	public String getIsEmptyRetCode() {
		return isEmptyRetCode;
	}

	public void setIsEmptyRetCode(String isEmptyRetCode) {
		this.isEmptyRetCode = isEmptyRetCode;
	}

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "static", transferVal = "is_not_empty")
	private String isNotEmptyRetCode;

	public String getIsNotEmptyRetCode() {
		return isNotEmptyRetCode;
	}

	public void setIsNotEmptyRetCode(String isNotEmptyRetCode) {
		this.isNotEmptyRetCode = isNotEmptyRetCode;
	}

	@ModuleParam(required = false)
	private String target;

	public String getTarget() {
		return target;
	}

	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 * 空(NULL)文字チェック.
	 *
	 * @param ModuleContext
	 * @return ModuleResult (ResultCode＝is_emptyの場合空
	 *         ResultCode＝is_not_emptyの場合空以外)
	 **/
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();

		// パラメータが空の場合
		if (StringUtils.isEmpty(getTarget())) {
			result.getReturnData().put("is_empty", getIsEmptyRetCode());
			result.setResultCode("is_empty");
		} else {
			// パラメータが空以外の場合
			result.getReturnData().put("is_not_empty", getIsNotEmptyRetCode());
			result.setResultCode("is_not_empty");
		}
		return result;
	}

}
