package jp.ill.photon.module.common;

import org.apache.commons.lang3.StringUtils;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * 次の遷移先を設定するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class SetNextPathModule implements PhotonModule {

	@ModuleParam(required = true)
	private String nextPath;

	@ModuleParam(required = false)
	private String resultType;

	/**
	 * 次の遷移先を設定するメソッド
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();

		String nextPath = getNextPath();

		if (!StringUtils.isEmpty(nextPath)) {
			result.setNextPath(nextPath);

			String resultType = getResultType();
			if (StringUtils.isEmpty(resultType)) {
				resultType = ModuleResult.ResultTypes.REDIRECT;
			}

			result.setResultType(resultType);
			result.setResultCode("set_data");
		} else {
			result.setResultCode("no_data");
		}
		return result;
	}

	public void setNextPath(String nextPath) {
		this.nextPath = nextPath;
	}

	public String getNextPath() {
		return nextPath;
	}

	public String getResultType() {
		return resultType;
	}

	public void setResultType(String resultType) {
		this.resultType = resultType;
	}

}
