package jp.ill.photon.module.common;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 *
 * [add_message] クライアント出力用メッセージを追加するモジュール.
 *
 * <p>
 * パラメータで指定された内容でアクションが出力するメッセージを追加する。
 * </p>
 *
 * <p>
 * <h2>DTOへの設定値：</h2>
 * <dl>
 * <dt>なし</dt>
 * <dd>メッセージ追加のみ</dd>
 * </dl>
 * </p>
 *
 * @author m_fukukawa
 *
 */
@ModuleVersion("1.0.0")
public class SetMessagesModule implements PhotonModule {

	/**
	 * メッセージ内容セットモジュールパラメータ.
	 *
	 * <p>
	 * dtoのメッセージ情報をMessagesに入れる。
	 * </p>
	 *
	 * <p>
	 * パラメータ指定例：<br/>
	 * <dl>
	 * <dt>transfer_type</dt>
	 * <dd>static_json</dd>
	 * <dt>transfer_val</dt>
	 * <dd>
	 *
	 * <pre>
	 * [
	 *   {
	 *     "set_messages": {
	 *       "type": "dto"
	 *       "val": "messages"
	 *     }
	 *   }
	 * ]
	 * </pre>
	 *
	 * </dl>
	 */
	@ModuleParam(required = true)
	private Map<String, Object> setMessages;


	@Override
	public ModuleResult execute(ModuleContext context) {


		ModuleResult result = new ModuleResult();

		Map<String, Object> returnMessages = new HashMap<String, Object>();

			returnMessages.putAll(setMessages);

		result.setMessages(returnMessages);
		result.setResultCode("add");
		// result.getReturnData().put(dtoKey, setListMap);

		return result;

	}

	/**
	 * setMessagesを取得します。
	 *
	 * @return setMessages
	 */
	public Map<String, Object> getSetMessages() {
		return setMessages;
	}

	/**
	 * setMessagesを設定します。
	 *
	 * @param setMessages
	 */
	public void setSetMessages(Map<String, Object> setMessages) {
		this.setMessages = setMessages;
	}
}
