package jp.ill.photon.module.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.jfree.util.Log;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;

/**
 * 外部プロセスを起動するモジュール（外部プロセスの終了は待たない）
 *
 * @author h_tanaka
 *
 */
public class ProcessRunnerNoWaitModule implements PhotonModule {

	@ModuleParam(required = true)
	private String workDir;

	@ModuleParam(required = true)
	private String command;

	@ModuleParam(required = false)
	private List<Map<String, Object>> args;

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		List<String> cmd = new ArrayList<>();
		cmd.add(getCommand());

		if (args != null) {
			for (Map<String, Object> mp : args) {
				if (mp.containsKey("key")) {
					cmd.add((String) mp.get("key"));
				}
				cmd.add((String) ParamUtil.getParamValueByType((String) mp.get("transfer_type"),
						mp.get("transfer_val"), context.getDto()));
			}
		}

		cmd.add(">");
		cmd.add("stdout.txt");
		cmd.add("2>");
		cmd.add("stderr.txt");
		Log.info(cmd.stream().collect(Collectors.joining(" ")));
		ProcessBuilder pb = new ProcessBuilder(cmd);
		pb.directory(new File(getWorkDir()));
		try {
			Process process = pb.start();
			// process.waitFor();
		} catch (IOException e) {
			throw new PhotonModuleException("プロセスの起動に失敗しました", e);
		}

		ModuleResult result = new ModuleResult();
		return result;
	}

	public String getCommand() {
		return command;
	}

	public void setCommand(String command) {
		this.command = command;
	}

	public String getWorkDir() {
		return workDir;
	}

	public void setWorkDir(String workDir) {
		this.workDir = workDir;
	}

	public List<Map<String, Object>> getArgs() {
		return args;
	}

	public void setArgs(List<Map<String, Object>> args) {
		this.args = args;
	}
}
