package jp.ill.photon.module.common;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * パラメータで与えられた結果コードをそのまま返すリダイレクト・フォワード用モジュール
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class PassModule implements PhotonModule {

	@ModuleParam(required = true)
	private String resultCode;

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {
		ModuleResult result = new ModuleResult();
		result.setResultCode(resultCode);
		return result;
	}

}
