package jp.ill.photon.module.common;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.UtilTools;

/**
 * 暗号化するモジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class EncryptModule implements PhotonModule {

	@ModuleParam(required = true)
	private String encryptKey = "";

	@ModuleParam(required = false)
	private String rawText = "";

	/**
	 * 暗号化するメソッド
	 *
	 * パラメータの（案件固有の）暗号化キーで、 パラメータのobjectDataを暗号化します。
	 *
	 * @param context コンテキスト
	 * @return モジュール結果クラス
	 *
	 */
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		String encryptString = "";
		if (!UtilTools.isEmpty(getRawText())) {

			// (案件固有の暗号化キーを使って)パスワードを暗号化(ハッシュ化)する
			encryptString = CryptUtil.digestPassword(getRawText(),
					getEncryptKey());
		}

		result.getReturnData().put("encrypted_text", encryptString);
		return result;
	}

	public String getEncryptKey() {
		return encryptKey;
	}

	public void setEncryptKey(String encryptKey) {
		this.encryptKey = encryptKey;
	}

	public String getRawText() {
		return rawText;
	}

	public void setRawText(String rawText) {
		this.rawText = rawText;
	}
}
