package jp.ill.photon.module.common;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.lang3.StringUtils;

/**
 * 引数のJSON文字列をマップ、またはリストに変換するモジュール
 *
 * @author m_fukukawa
 *
 */
public class ConvertFromJsonToObjectModule implements PhotonModule {

	/* 変換対象文字列 */
	@ModuleParam(required=false)
	private Map<String, Object> convertTargetString;

	@Override
	public ModuleResult execute(ModuleContext context) {

		Map<String, Object> ret = new HashMap<String, Object>();

		if (convertTargetString != null) {

			for (Map.Entry<String, Object> e : convertTargetString.entrySet()) {

				String value = ParamUtil.getParamStrValueByType(e.getValue(), context.getDto());
				Object out = null;

				if (!StringUtils.isEmpty(value)) {
					if (JsonUtil.isAbleToConverToMap(value)) {
						out = JsonUtil.jsonToMap(value);
					} else if (JsonUtil.isAbleToConverToList(value)) {
						out = JsonUtil.jsonToList(value);
					}
				}

				ret.put(e.getKey(), out);

			}

		}

		ModuleResult result = new ModuleResult();
		result.getReturnData().put("returns", ret);

		return result;

	}

	/**
	 * convertTargetStringを取得します。
	 * @return convertTargetString
	 */
	public Map<String, Object> getConvertTargetString() {
		return convertTargetString;
	}

	/**
	 * convertTargetStringを設定します。
	 * @param convertTargetString
	 */
	public void setConvertTargetString(Map<String, Object> convertTargetString) {
		this.convertTargetString = convertTargetString;
	}

}
