package jp.ill.photon.module.common;

import jp.ill.photon.action.ActionDispatcher;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;

/**
 * 2つのパラメータを比較して結果を返すモジュール
 * 返却するReturnDataの値も指定できる。
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class ComparatorModule implements PhotonModule {


	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "is_equal")
	private String isEqualRetCode;

	public String getIsEqualRetCode() {
		return isEqualRetCode;
	}

	public void setIsEqualRetCode(String isEqualRetCode) {
		this.isEqualRetCode = isEqualRetCode;
	}

	@ModuleParam(required=false)
	@DefaultParamSetting(transferType = "static", transferVal = "is_not_equal")
	private String isNotEqualRetCode;

	public String getIsNotEqualRetCode() {
		return isNotEqualRetCode;
	}

	public void setIsNotEqualRetCode(String isNotEqualRetCode) {
		this.isNotEqualRetCode = isNotEqualRetCode;
	}

	@ModuleParam(required=false)
	private Object src;

	public Object getSrc() {
		return src;
	}

	public void setSrc(Object src) {
		this.src = src;
	}

	@ModuleParam(required=false)
	private Object dest;

	public Object getDest() {
		return dest;
	}

	public void setDest(Object dest) {
		this.dest = dest;
	}

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(ActionDispatcher.class);

	@Override
	public ModuleResult execute( ModuleContext context ) {
		ModuleResult result = new ModuleResult();
		//if (src.equals(dest)) {
		logger.info( String.format("---->[src]:[%s]", src) );
		logger.info( String.format("---->[dest]:[%s]", dest) );
		if (java.util.Objects.equals(src, dest)) {
			logger.info("---->[is_equals]");
			result.getReturnData().put("result_code", getIsEqualRetCode());
			result.setResultCode("is_equal");
		} else {
			logger.info("---->[is_not_equal]");
			result.getReturnData().put("result_code", getIsNotEqualRetCode());
			result.setResultCode("is_not_equal");
		}

		return result;
	}

}
