package jp.ill.photon.module.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.action.ActionDispatcher;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.CollectionUtils;

/**
 *
 * mapsの中で定義されたリストをすべて結合し、できたマップを返却する
 *
 * @author m_fukukawa
 *
 */
public class CombineMapModule implements PhotonModule {

	@ModuleParam(required = false)
	private List<Map<String, Object>> maps; // 結合対象リスト

	// モジュール内で使用する変数
	/** DTO */
	ActionDto dto;

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(ActionDispatcher.class);

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute( ModuleContext context ) {

		dto = context.getDto();

		Map<String, Object> ret = new HashMap<String, Object>();

		if (!CollectionUtils.isEmpty(maps)) {

			for (Map<String, Object> mp : maps) {

				Map<String, Object> map = (Map<String, Object>)
						ParamUtil.getParamObjectValueByType(mp, dto);

				ret.putAll(map);

			}

		}

		ModuleResult result = new ModuleResult();
		result.getReturnData().put("combined_map", ret);

		return result;

	}

	/**
	 * mapsを取得します。
	 * @return maps
	 */
	public List<Map<String, Object>> getMaps() {
		return maps;
	}

	/**
	 * mapsを設定します。
	 * @param maps
	 */
	public void setMaps(List<Map<String, Object>> maps) {
		this.maps = maps;
	}


}
