package jp.ill.photon.module.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.action.ActionDispatcher;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.LogUtil;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.CollectionUtils;

/**
 *
 * listsの中で定義されたリストをすべて結合し、できたリストを返却する
 *
 * @author m_fukukawa
 *
 */
public class CombineMapListModule implements PhotonModule {

	@ModuleParam(required = false)
	private List<Map<String, Object>> lists; // 結合対象リスト

	// モジュール内で使用する変数
	/** DTO */
	ActionDto dto;

	/** ログ用変数 */
	protected final LogUtil logger = new LogUtil(ActionDispatcher.class);

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute( ModuleContext context ) {

		dto = context.getDto();

		List<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();

		if (!CollectionUtils.isEmpty(lists)) {

			for (Map<String, Object> mp : lists) {

				List<Map<String, Object>> list = (List<Map<String, Object>>)
						ParamUtil.getParamObjectValueByType(mp, dto);

				ret.addAll( new ArrayList<Map<String, Object>>( list ) );

			}

		}

		ModuleResult result = new ModuleResult();
		int cnt = 0;
		if (!ret.isEmpty()) {
			if (ret.get(0).get("count") != null) {
				cnt = Integer.parseInt(ret.get(0).get("count").toString());
			} else {
				cnt = ret.size();
			}
		}

		result.getReturnData().put("first", (ret.isEmpty())? null : ret.get(0));
		result.getReturnData().put("list", ret);
		result.getReturnData().put("cnt", cnt);

		return result;

	}

	/**
	 * listsを取得します。
	 * @return lists
	 */
	public List<Map<String, Object>> getLists() {
		return lists;
	}

	/**
	 * listsを設定します。
	 * @param lists
	 */
	public void setLists(List<Map<String, Object>> lists) {
		this.lists = lists;
	}

}
