package jp.ill.photon.module.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.ParamUtil;

import org.apache.commons.collections.MapUtils;

@ModuleVersion("1.0.0")
public class ArraysToMapListModule implements PhotonModule {

	@ModuleParam(required=true)
	private Map<String, Object> variables;

	ActionDto dto;
	Map<String, Object> request;

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		dto = context.getDto();
		request = context.getDto().getRawParams();

		List<Map<String, Object>> retMapList = new ArrayList<Map<String, Object>>();
		List<Map<String, Object>> retMapParamList = new ArrayList<Map<String, Object>>();
		Map<String, Object> retMap = new HashMap<String, Object>();

		Map<String, Object> arrayMap = new HashMap<String, Object>();
		Map<String, String> typeMap = new HashMap<String, String>();

		// パラメータから、配列として扱う項目名を取得
		int maxArraySize = 0;
		for (String key : variables.keySet()) {

			Map<String, Object> mp = (Map<String, Object>) variables.get(key);

			String type = (String) mp.get("transfer_type");

			Object paramValues = ParamUtil.getParamValueByType(type, mp.get("transfer_val"), dto);

			int thisArraySize = getSize(key); // 1項目あたりのサイズ

			if (maxArraySize < thisArraySize) {
				maxArraySize = thisArraySize;
			}

			arrayMap.put(key, paramValues);
			typeMap.put(key, type);

		}

		if (!MapUtils.isEmpty(arrayMap)) {

			for (int i = 0; i < maxArraySize; i++) {

				Map<String, Object> retValMap = new HashMap<String, Object>();
				Map<String, Object> retValParamMap = new HashMap<String, Object>();

				String idx = Integer.toString(i);
				retValMap.put("idx", idx);
				retValParamMap.put("idx", new HashMap<String, Object>(){{
					put("type", "static");
					put("val", idx);
				}});

				for (String key : arrayMap.keySet()) {

					if (ParamUtil.TransferTypes.PARAM_ARRAY.equals(typeMap.get(key))) {

						String[] array = (String[]) arrayMap.get(key);
						String value = (array != null && array.length > i)? array[i] : null;
						retValMap.put(key, value);
						retValParamMap.put(key, new HashMap<String, Object>(){{
							put("type", "static");
							put("val", value);
						}});

					} else if (ParamUtil.TransferTypes.PARAM_ARRAY_MULTI.equals(typeMap.get(key))) {

						String[][] array = (String[][]) arrayMap.get(key);
						String[] value = (array != null && array.length > i)? array[i] : null;
						retValMap.put(key, value);
						retValParamMap.put(key, new HashMap<String, Object>(){{
							put("type", "static");
							put("val", value);
						}});

					} else if (ParamUtil.TransferTypes.PARAM_ARRAY_FILE.equals(typeMap.get(key))) {

						String[] array = (String[]) arrayMap.get(key);
						String value = (array != null && array.length > i)? array[i] : null;
						retValMap.put(key, value);
						retValParamMap.put(key, new HashMap<String, Object>(){{
							put("type", "static");
							put("val", value);
						}});

					}

					retMap.put(key + "[" + retValMap.get("idx") + "]", retValMap.get(key));

				}

				retMapList.add(retValMap);
				retMapParamList.add(retValParamMap);

			}

		}

		result.getReturnData().put("map_list", retMapList);
		result.getReturnData().put("map", retMap);
		result.getReturnData().put("map_param_list", retMapParamList);
		result.setResultCode("set");

		return result;

	}


	/***
	 *
	 * 引数の項目名を持つ添え字付の入力項目から、最大の配列のサイズを返却
	 *
	 * @param key
	 * @return
	 */
	private int getSize(String key) {

		// リクエスト情報の中身を見て
		// key[<<数字>>]の項目を取得し、
		// その中で<<数字>>が一番大きなサイズを返却
		int max = 0;
		for (Map.Entry<String, Object> e : request.entrySet()) {

			// 数値部分取得
			int size = 0;
			Matcher m = Pattern.compile("^" + key + "\\[(0|[1-9][0-9]*)\\]$")
					.matcher(e.getKey());
			if (m.find()){

				// 添え字を数値化
				String idxStr = (m.groupCount() == 1)? m.group(1) : "";
				if (idxStr != null && !idxStr.isEmpty()) {

					size = Integer.parseInt(idxStr) + 1;

				}

			}

			if (max < size) {
				max = size;
			}

		}

		return max;

	}

	/**
	 * variablesを取得します。
	 * @return variables
	 */
	public Map<String, Object> getVariables() {
		return variables;
	}

	/**
	 * variablesを設定します。
	 * @param variables
	 */
	public void setVariables(Map<String, Object> variables) {
		this.variables = variables;
	}

}
