package jp.ill.photon.module.cart;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.query.SqlSelectQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;

public class UpdateSelectedDeliveryModule implements PhotonModule {

    @ModuleParam(required=false)
    private String sessionKeyUserDelivery = "aec_user_delivery";

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.priceCalcType.note")
    private String priceCalcType;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.verNo.note")
    private String aoVersion;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
    private String userCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
    private int userChargeId;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_name")
    private String chargeName;

    @ModuleParam(required = true, paramGroup=true)
    private Delivery delivery = new Delivery();

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param", transferVal = "_init.tenant_id")
	private String tenantId;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

    public String getSessionKeyUserDelivery() {
        return sessionKeyUserDelivery;
    }

    public void setSessionKeyUserDelivery(String sessionKeyUserDelivery) {
        this.sessionKeyUserDelivery = sessionKeyUserDelivery;
    }

    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    public int getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(int userChargeId) {
        this.userChargeId = userChargeId;
    }

    public String getChargeName() {
        return chargeName;
    }

    public void setChargeName(String chargeName) {
        this.chargeName = chargeName;
    }

    public String getAoVersion() {
        return aoVersion;
    }

    public void setAoVersion(String aoVersion) {
        this.aoVersion = aoVersion;
    }

    public String getPriceCalcType() {
        return priceCalcType;
    }

    public void setPriceCalcType(String priceCalcType) {
        this.priceCalcType = priceCalcType;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public Delivery getDelivery() {
        return delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

    @Override
    public ModuleResult execute( ModuleContext context ) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        // お届け先情報
        Map<String, Object> deliveryInputMap = delivery.toMap();

        // 再選択したお届け先をセッションに積む
        context.getDto().getSession().setAttribute(sessionKeyUserDelivery, deliveryInputMap);

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		SqlSelectQueryFactory selectFactory = SqlSelectQueryFactory.newInstance();

		delivery = createData(deliveryInputMap);

		/** 得意先担当者テーブルの更新 */
		HashMap<String, Object> upsertUserChargeInfoParamMap = createUpsertUserChargeInfoParams();
		SqlSelectQuery upsertUserChargeInfoQuery = selectFactory.createSelectQueryFromFile(
				upsertUserChargeInfoParamMap, context.getDto(),
				sqlFileDirPath, "aec20/user_charge_info/insertUpdateUserChargeInfo.sql");
		upsertUserChargeInfoQuery.prepare();

		// 更新処理を実行
		List<Map<String, Object>> upsertResult = tm.required(() -> {
			SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
					upsertUserChargeInfoQuery,
					new MapResultListHandler(MapKeyNamingType.NONE));
			return command.execute();
		});

        // TODO そもそもここでカートテーブルの単価更新はしない。カートテーブルには単価を持たない方針
        // 得納商単価採用の場合は、カートの価格の更新
//        if (AoSetting.UserItemPriceAdoptDiv.USER_DELIVERY_ITEM.equals(aoSetting.getUserPriceAdoptDiv())) {
//
//          String condStrInTax = "TBL_BU.VAL->>$$tax_div$$ = $$2$$ AND (BI.VAL->>$$tax_bracket_cd$$)::int NOT IN (0, 9)"; // TODO: 暫定。本当は外から渡すのではなくSQLの中で計算する
//          String condStrNoTax = "TBL_BU.VAL->>$$tax_div$$ <> $$2$$ OR (BI.VAL->>$$tax_bracket_cd$$)::int IN (0, 9)"; // TODO: 暫定。本当は外から渡すのではなくSQLの中で計算する
//
//          String userPriceAdoptDiv = aoSetting.getUserPriceAdoptDiv();
//          String uriageTankaSaiyoDiv = aoSetting.getUriageTankaSaiyoDiv();


//          TransactionManager tm = DomaConfig.singleton().getTransactionManager();
//          JsonDataDao dao = new JsonDataDaoImpl();
//          int res = tm.required(() -> {
//              // OrderNoの採番と採番テーブルの更新
//              List<Map<String, Object>> cartPriceList = dao.getCartPriceList(context.getDto().getTenantId(), userCd,
//                      String.valueOf(userChargeId), uriageTankaSaiyoDiv, condStrInTax, condStrNoTax, userPriceAdoptDiv, uriageTankaSaiyoDiv, delivery.getUserDeliveryCd());
//              if (cartPriceList == null || cartPriceList.isEmpty()) {
//                  return -1;
//              }
//
//              return 0;
//          });
//        }

        // ダイアログを閉じるフラグ
        result.getReturnData().put("close_flg", "true");

        return result;
    }

	/**
	 * お届け先情報をモデルに設定
	 *
	 * @param deliveryInputMap お届け先入力値
	 * @return
	 */
	public Delivery createData(Map<String, Object> deliveryInputMap) {

		// 入力値をそのままモデルにコピー
		Delivery model = Delivery.valueOf(deliveryInputMap);

		// 個別に値を設定
		// お届け先名
		String userDeliveryName = (String) deliveryInputMap.get("user_delivery_name1");
		if (!CheckUtil.isEmpty(userDeliveryName)) {
			// お届け先名の入力フォームの値を30バイトで分割
			String[] name = StringUtil.lengthSplitBytes(
					userDeliveryName, 30, "Windows-31J");
			model.setUserDeliveryName1(name[0]);
			if (name.length >= 2) {
				model.setUserDeliveryName2(name[1]);
			} else {
				model.setUserDeliveryName2("");
			}
		}else{
			model.setUserDeliveryName1("");
			model.setUserDeliveryName2("");
		}

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();

		model.setUserCd(StringUtil.defaultString(this.getUserCd(), ""));

		model.setUpdateDatetime(nowDatetime);
		model.setUpdateUserName(StringUtil.defaultString(this.getChargeName(), ""));
		model.setUpdateDiv(1);
		model.setInsertDatetime(nowDatetime);
		model.setInsertUserName(StringUtil.defaultString(this.getChargeName(), ""));
		model.setInsertDiv(1);

		return model;
	}

	private Map<String, Object> toSubMap(String val){
		 Map<String, Object> subMap = new  LinkedHashMap<String, Object>();
		 subMap.put("type", "static");
		 subMap.put("val", val);
		 return subMap;
	}

	/** 得意先担当者テーブル更新SQLパラメータ作成 */
	private HashMap<String, Object> createUpsertUserChargeInfoParams() {
		HashMap<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("tenantId", toSubMap(tenantId));
		paramMap.put("userCd", toSubMap(userCd));
		paramMap.put("userChargeId", toSubMap(StringUtil.defaultString(userChargeId)));
		paramMap.put("userDeliveryCd", toSubMap(delivery.getUserDeliveryCd()));
		paramMap.put("userDeliveryName1", toSubMap(delivery.getUserDeliveryName1()));
		paramMap.put("userDeliveryName2", toSubMap(delivery.getUserDeliveryName2()));
		paramMap.put("zip", toSubMap(delivery.getZip()));
		paramMap.put("cityName1", toSubMap(delivery.getCityName1()));
		paramMap.put("cityName2", toSubMap(delivery.getCityName2()));
		paramMap.put("cityName3", toSubMap(delivery.getCityName3()));
		paramMap.put("tel", toSubMap(delivery.getTel()));
		paramMap.put("fax", toSubMap(delivery.getFax()));
		paramMap.put("insertUserName", toSubMap(delivery.getInsertUserName()));
		paramMap.put("insertDatetime", toSubMap(delivery.getInsertDatetime()));
		paramMap.put("insertDiv", toSubMap(StringUtil.defaultString(delivery.getInsertDiv())));
		paramMap.put("updateUserName", toSubMap(delivery.getUpdateUserName()));
		paramMap.put("updateDatetime", toSubMap(delivery.getUpdateDatetime()));
		paramMap.put("updateDiv", toSubMap(StringUtil.defaultString(delivery.getUpdateDiv())));

		return paramMap;
	}


}
