package jp.ill.photon.module.cart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;

import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.query.SqlSelectQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

public class UpdateInputedDeliveryModule implements PhotonModule {

    @ModuleParam(required=false)
    private String sessionKeyUserDelivery = "aec_user_delivery";

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="cart_delivery_input")
    private Map<String, Object> cartDeliveryInput;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.errormessage")
    private Map<String, Object> errorMessage;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.priceCalcType.note")
    private String priceCalcType;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.verNo.note")
    private String aoVersion;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
    private String userCd;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_name")
    private String chargeName;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
    private int userChargeId;

    @ModuleParam(required = true, paramGroup=true)
    private Delivery delivery = new Delivery();

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param", transferVal = "_init.tenant_id")
	private String tenantId;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	/** メッセージID（お届け先登録エラー） */
    public static final String DEL_ERROR_MSG_ID = "deliveryErrMes4";

    public String getSessionKeyUserDelivery() {
        return sessionKeyUserDelivery;
    }

    public void setSessionKeyUserDelivery(String sessionKeyUserDelivery) {
        this.sessionKeyUserDelivery = sessionKeyUserDelivery;
    }

    public String getUserCd() {
        return userCd;
    }

    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    public String getChargeName() {
        return chargeName;
    }

    public void setChargeName(String chargeName) {
        this.chargeName = chargeName;
    }

    public int getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(int userChargeId) {
        this.userChargeId = userChargeId;
    }

    public String getAoVersion() {
        return aoVersion;
    }

    public void setAoVersion(String aoVersion) {
        this.aoVersion = aoVersion;
    }

    public String getPriceCalcType() {
        return priceCalcType;
    }

    public void setPriceCalcType(String priceCalcType) {
        this.priceCalcType = priceCalcType;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public Map<String, Object> getCartDeliveryInput() {
        return cartDeliveryInput;
    }

    public void setCartDeliveryInput(Map<String, Object> cartDeliveryInput) {
        this.cartDeliveryInput = cartDeliveryInput;
    }

    public Map<String, Object> getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(Map<String, Object> errorMessage) {
        this.errorMessage = errorMessage;
    }

	public String getTenantId() {
		return tenantId;
	}

	public void setTenantId(String tenantId) {
		this.tenantId = tenantId;
	}

	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

    public Delivery getDelivery() {
        return delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    @Override
    public ModuleResult execute( ModuleContext context ) throws PhotonModuleException {
        ModuleResult moduleResult = new ModuleResult();

        // お届け先入力値
        Map<String, Object> deliveryInputMap = delivery.toMap();

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		SqlSelectQueryFactory selectFactory = SqlSelectQueryFactory.newInstance();

		delivery = createData(deliveryInputMap);

		boolean closeFlg = false;

		if (!CheckUtil.isEmpty(delivery.getUserDeliveryCd())) {

		} else {

			/** お届け先存在チェック */
			HashMap<String, Object> dupCheckParams = createDupDeliveryParams();
			SqlSelectQuery dupCheckQuery = selectFactory.createSelectQueryFromFile(
					dupCheckParams, context.getDto(),
					sqlFileDirPath, "aec20/user_delivery/getCheckData.sql");
			dupCheckQuery.prepare();

			// 検索処理を実行
			List<Map<String, Object>> sameDeliveryData = tm.required(() -> {
				SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
						dupCheckQuery,
						new MapResultListHandler(MapKeyNamingType.NONE));
				return command.execute();
			});

			if (sameDeliveryData != null && sameDeliveryData.size() > 0) {

			    // そもそもこのモジュールが呼ばれていなさそうだが一応修正。
				//String deliveryErrMes4 = (String)((Map<?, ?>)errorMessage.get("deliveryErrMes4")).get("note");
				//moduleResult.getReturnData().put("messages", deliveryErrMes4);


				List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
	            ActionDtoMessage msg = new ActionDtoMessage();
	            msg.setMessageId(DEL_ERROR_MSG_ID);
	            errorMessages.add(msg);
	            moduleResult.getMessages().put("error_page", errorMessages);

			} else {

				/** お届け先新規登録 */
				HashMap<String, Object> insertDeliveryParamMap = createInsertDeliveryParams();
				SqlSelectQuery insertDeliveryQuery = selectFactory.createSelectQueryFromFile(
						insertDeliveryParamMap, context.getDto(),
						sqlFileDirPath, "aec20/user_delivery/insertDeliveryData.sql");
				insertDeliveryQuery.prepare();

				// 登録処理を実行
				List<Map<String, Object>> insertResult = tm.required(() -> {
					SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
							insertDeliveryQuery,
							new MapResultListHandler(MapKeyNamingType.NONE));
					return command.execute();
				});

				// 正常終了時
				if(insertResult != null && insertResult.size() > 0 && (int)insertResult.get(0).get("sp_insert_entity") == 0){
				    // 入力したお届け先をセッションに積む
				    context.getDto().getSession().setAttribute(sessionKeyUserDelivery, deliveryInputMap);
				    closeFlg = true;
				}
			}
			// ダイアログを閉じるフラグをセット
	        moduleResult.getReturnData().put("close_flg", String.valueOf(closeFlg));
		}

        return moduleResult;
    }

	/**
	 * お届け先入力値をモデルに設定
	 *
	 * @param deliveryInputMap お届け先入力値
	 * @return
	 */
	public Delivery createData(Map<String, Object> deliveryInputMap) {

		// 入力値をそのままモデルにコピー
		Delivery model = Delivery.valueOf(deliveryInputMap);

		// 個別に値を設定
		// お届け先名
		String userDeliveryName = (String) deliveryInputMap.get("user_delivery_name1");
		if (!CheckUtil.isEmpty(userDeliveryName)) {
			// お届け先名の入力フォームの値を30バイトで分割
			String[] name = StringUtil.lengthSplitBytes(
					userDeliveryName, 30, "Windows-31J");
			model.setUserDeliveryName1(name[0]);
			if (name.length >= 2) {
				model.setUserDeliveryName2(name[1]);
			} else {
				model.setUserDeliveryName2("");
			}
		}else{
			model.setUserDeliveryName1("");
			model.setUserDeliveryName2("");
		}

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();

		model.setUserCd(StringUtil.defaultString(this.getUserCd(), ""));
		model.setChargeName(StringUtil.defaultString(this.getChargeName(), ""));

		model.setUpdateDatetime(nowDatetime);
		model.setUpdateUserName(StringUtil.defaultString(this.getChargeName(), ""));
		model.setUpdateDiv(1);
		model.setInsertDatetime(nowDatetime);
		model.setInsertUserName(StringUtil.defaultString(this.getChargeName(), ""));
		model.setInsertDiv(1);

		return model;
	}

	private Map<String, Object> toSubMap(String val){
		 Map<String, Object> subMap = new  LinkedHashMap<String, Object>();
		 subMap.put("type", "static");
		 subMap.put("val", val);
		 return subMap;
	}

	/** お届け先存在チェックSQLパラメータ作成 */
	private HashMap<String, Object> createDupDeliveryParams() {
		HashMap<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("tenantId", toSubMap(tenantId));
		paramMap.put("userCd", toSubMap(userCd));
		paramMap.put("name", toSubMap(delivery.getUserDeliveryName()));
		paramMap.put("zip", toSubMap(delivery.getZip()));
		paramMap.put("cityName1", toSubMap(delivery.getCityName1()));
		paramMap.put("cityName2", toSubMap(delivery.getCityName2()));
		paramMap.put("cityName3", toSubMap(delivery.getCityName3()));
		paramMap.put("tel", toSubMap(delivery.getTel()));
		paramMap.put("fax", toSubMap(delivery.getFax()));

		return paramMap;
	}

	/** お届け先新規登録SQLパラメータ作成 */
	private HashMap<String, Object> createInsertDeliveryParams() {
		HashMap<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("tenantId", toSubMap(tenantId));
		paramMap.put("userCd", toSubMap(userCd));
		paramMap.put("userDeliveryName1", toSubMap(delivery.getUserDeliveryName1()));
		paramMap.put("userDeliveryName2", toSubMap(delivery.getUserDeliveryName2()));
		paramMap.put("zip", toSubMap(delivery.getZip()));
		paramMap.put("cityName1", toSubMap(delivery.getCityName1()));
		paramMap.put("cityName2", toSubMap(delivery.getCityName2()));
		paramMap.put("cityName3", toSubMap(delivery.getCityName3()));
		paramMap.put("tel", toSubMap(delivery.getTel()));
		paramMap.put("fax", toSubMap(delivery.getFax()));
		paramMap.put("chargeName", toSubMap(delivery.getChargeName()));
		paramMap.put("insertUserName", toSubMap(delivery.getInsertUserName()));
		paramMap.put("insertDatetime", toSubMap(delivery.getInsertDatetime()));
		paramMap.put("insertDiv", toSubMap(StringUtil.defaultString(delivery.getInsertDiv())));
		paramMap.put("updateUserName", toSubMap(delivery.getUpdateUserName()));
		paramMap.put("updateDatetime", toSubMap(delivery.getUpdateDatetime()));
		paramMap.put("updateDiv", toSubMap(StringUtil.defaultString(delivery.getUpdateDiv())));

		return paramMap;
	}


}
