package jp.ill.photon.module.cart;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;

public class SumPriceModule implements PhotonModule {

    @ModuleParam(required=true)
    private Map<String, Object> prices;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
    private AoSetting aoSetting;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

    public Map<String, Object> getPrices() {
        return prices;
    }

    public void setPrices(Map<String, Object> prices) {
        this.prices = prices;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        String resultPrice = "0";

        // 対象パラメータを変換して加算
        Map<String, Object> params = new LinkedHashMap<String, Object>();
        if (prices != null) {
            Map<String, String> paramInfo = null;
            for (Map.Entry<String, Object> param : prices.entrySet()) {
                paramInfo = (Map) param.getValue();
                Object paramValue = ParamUtil.getParamValueByType(
                        paramInfo.get("transfer_type"), paramInfo.get("transfer_val"), context.getDto());
                params.put(param.getKey(), paramValue);

                if (paramValue != null) {
                    resultPrice = UtilTools.addBigDecimal(resultPrice, (new BigDecimal(String.valueOf(paramValue).replace(",", "")).toString()));
                }
            }
        }

        String resultPriceFormat = AoUtil.convAoRoundingSalesPrice(resultPrice, aoSetting.getSalesPriceDigitNum(), StringUtil.defaultString(userForm.get("price_fraction_div"), "0") );

        result.getReturnData().put("result_price", resultPriceFormat);

        return result;
    }

}
