package jp.ill.photon.module.cart;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

import org.apache.commons.collections.CollectionUtils;
import org.seasar.doma.jdbc.tx.TransactionManager;

public class GetSelectedDeliveryModule implements PhotonModule {

    // デフォルト値は、ここで設定する
    @ModuleParam(required=true, domainObject=true)
    private User user = null;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
    private int userChargeId;

    @ModuleParam(required=false)
    private Map<String, Object> sessionUserDelivery;

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getUserChargeId() {
        return userChargeId;
    }

    public void setUserChargeId(int userChargeId) {
        this.userChargeId = userChargeId;
    }

    public Map<String, Object> getSessionUserDelivery() {
        return sessionUserDelivery;
    }

    public void setSessionUserDelivery(Map<String, Object> sessionUserDelivery) {
        this.sessionUserDelivery = sessionUserDelivery;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        if (sessionUserDelivery == null) {
            TransactionManager tm = DomaConfig.singleton().getTransactionManager();
            JsonDataDao dao = new JsonDataDaoImpl();

            Delivery delivery = tm.required(() -> {
                List<Map<String, Object>> deliveryMap = dao.getLastSelectedDelivery(context.getDto().getTenantId(), user.getUserCd(), userChargeId);
                if (CollectionUtils.isEmpty(deliveryMap)) {
                    return null;
                }
                else {
                    return Delivery.valueOf(deliveryMap.get(0));
                }
            });

            result.getReturnData().put("selected_delivery", ((delivery == null)? new HashMap<String, Object>() : delivery.toMap()));
        } else {
            result.getReturnData().put("selected_delivery", sessionUserDelivery);
        }

        // TODO お届け先利用権限がOFFだった場合、自社をセット
        // ユーザー情報は再取得する
        User userInfo = User.getUser(context.getDto(), user.getUserCd());
        //result.getReturnData().put("selected_user", user.toMap());

        return result;
    }

}
