package jp.ill.photon.module.cart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.CreditInput;
import jp.ill.photon.model.Order;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CheckUtil;

public class CheckOrderInputModule implements PhotonModule {

	@ModuleParam(required = true, paramGroup = true)
	private Order order = new Order();

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "static", transferVal = "aec_credit_input")
	private String sessionKeyCreditInput = "aec_credit_input";

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "cart.list")
	private List<Map<String, Object>> cartList;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "shohin_search.list")
	private List<Map<String, Object>> itemList;

	@ModuleParam(required = false)
	private String estimateNo;

	@ModuleParam(required = false)
	private String chumonFlg;

	@ModuleParam(required = false)
	private String estimateEndTimeFlg;

	@ModuleParam(required = false)
	private String redirectFlg;

	/** メッセージID（見積注文済みエラー） */
    public static final String CHUMON_FLG_ERROR_MSG_ID = "estChumonFlgErrMes";

    /** メッセージID（見積有効期限切れエラー） */
    public static final String ESTIMATE_END_TIME_ERROR_MSG_ID = "estEndTimeErrMes";

    public static final String CREDIT_INPUT_INVALID_MSG_ID = "creditInputInvalidMes";

    /* 確定処理用のメッセージID（見積有効期限切れエラー */
    public static final String REDIRECT_END_TIME_ERROR_MSG_ID = "estimateCartCheckMes";

    public static final String REDIRECT = "1";

	public String getEstimateEndTimeFlg() {
        return estimateEndTimeFlg;
    }

    public void setEstimateEndTimeFlg(String estimateEndTimeFlg) {
        this.estimateEndTimeFlg = estimateEndTimeFlg;
    }

    public String getChumonFlg() {
        return chumonFlg;
    }

    public void setChumonFlg(String chumonFlg) {
        this.chumonFlg = chumonFlg;
    }

    public String getEstimateNo() {
        return estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    public List<Map<String, Object>> getItemList() {
		return itemList;
	}

	public void setItemList(List<Map<String, Object>> itemList) {
		this.itemList = itemList;
	}

	public List<Map<String, Object>> getCartList() {
		return cartList;
	}

	public void setCartList(List<Map<String, Object>> cartList) {
		this.cartList = cartList;
	}

	public String getSessionKeyCreditInput() {
		return sessionKeyCreditInput;
	}

	public void setSessionKeyCreditInput(String sessionKeyCreditInput) {
		this.sessionKeyCreditInput = sessionKeyCreditInput;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public String getRedirectFlg() {
		return redirectFlg;
	}

	public void setRedirectFlg(String redirectFlg) {
		this.redirectFlg = redirectFlg;
	}

	@ModuleParam(required = false)
    @DefaultParamSetting(transferType = "dto", transferVal = "got_payment_session.selectedPaymentCd")
    private String sessionSelectedPaymentCd = null;

	public String getSessionSelectedPaymentCd() {
		return sessionSelectedPaymentCd;
	}

	public void setSessionSelectedPaymentCd(String sessionSelectedPaymentCd) {
		this.sessionSelectedPaymentCd = sessionSelectedPaymentCd;
	}

	@Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ModuleResult result = new ModuleResult();

		ActionDto dto = context.getDto();
		ActionParamMap paramMap = dto.getParams();

		// クレジット選択時は、クレジットカード入力情報をセッションに載せる
		String paymentCd = CheckUtil.isEmpty(order.getPaymentCd()) ? sessionSelectedPaymentCd : order.getPaymentCd();

		// リダイレクトフラグ
		String redirectFlg = paramMap.get("redirectFlg");

		if (order.isCreditSelected(paymentCd)) {
			HttpSession session = context.getDto().getSession();

			// session.removeAttribute(sessionKeyCreditInput);

			CreditInput creInput = (CreditInput) session
					.getAttribute(sessionKeyCreditInput + "-" + context.getDto().getTenantId() + "-" + context.getDto().getAppId());
			if (creInput != null) {
				order.setCreditNumber(creInput.getNumber());
				order.setCreditLimitMonth(creInput.getLimitMonth());
				order.setCreditLimitYear(creInput.getLimitYear());
				order.setCreditSecurityCd(creInput.getSecurityCd());
			} else {
				if (StringUtils.isEmpty(order.getCreditNumber()) || StringUtils.isEmpty(order.getCreditLimitMonth()) ||
						StringUtils.isEmpty(order.getCreditLimitYear())) {

					if (REDIRECT.equals(redirectFlg)) {
						result.setResultCode("error");

			            List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
			            ActionDtoMessage msg = new ActionDtoMessage();
			            msg.setMessageId(REDIRECT_END_TIME_ERROR_MSG_ID);
			            errorMessages.add(msg);

			            result.getMessages().put("error_page", errorMessages);
			            return result;
					}else{
						result.setResultCode("error");

			            List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
			            ActionDtoMessage msg = new ActionDtoMessage();
			            msg.setMessageId(CREDIT_INPUT_INVALID_MSG_ID);
			            errorMessages.add(msg);

			            result.getMessages().put("error_page", errorMessages);
			            return result;
					}
				} else {
					creInput = new CreditInput();
					creInput.setNumber(order.getCreditNumber());
					creInput.setLimitMonth(order.getCreditLimitMonth());
					creInput.setLimitYear(order.getCreditLimitYear());
					creInput.setSecurityCd(order.getCreditSecurityCd());

					session.setAttribute(sessionKeyCreditInput + "-" + context.getDto().getTenantId() + "-" + context.getDto().getAppId(), creInput);
				}

			}

		}

		// 見積の有効チェック
		if (estimateNo != null) {
		    if ("1".equals(chumonFlg)) {
		        result.setResultCode("error");

	            List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
	            ActionDtoMessage msg = new ActionDtoMessage();
	            msg.setMessageId(CHUMON_FLG_ERROR_MSG_ID);
	            errorMessages.add(msg);

	            result.getMessages().put("error_page", errorMessages);
		    }
		    if ("1".equals(estimateEndTimeFlg)) {
		        result.setResultCode("error");

                List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                ActionDtoMessage msg = new ActionDtoMessage();
                msg.setMessageId(ESTIMATE_END_TIME_ERROR_MSG_ID);
                errorMessages.add(msg);

                result.getMessages().put("error_page", errorMessages);
		    }
		}


		// カート内容の変更チェックと在庫の表示
		boolean itemInvalidateCheck = true;
		if (cartList != null) {

		     // 商品情報を一旦マップに詰める
	        Map<String, Map<String, Object>> itemListMap = new HashMap<String, Map<String, Object>>();
	        if (itemList != null) {
	            for (Map<String, Object> itemMap : itemList) {
	                String itemCd = (String) itemMap.get("item_cd");
	                if (!itemListMap.containsKey(itemCd)) {
	                    itemListMap.put(itemCd, itemMap);
	                }
	            }
	        }

			for (int i = 0; i < cartList.size(); i++) {
				Map<String, Object> cartMap = cartList.get(i);

				//CartItem cartItem = CartItem.valueOf(cartMap);
				boolean isDisplay = cartMap.get("is_display") == null ? false : Boolean.valueOf(String.valueOf( cartMap.get("is_display") ));

				Map<String, Object> itemMap = itemListMap
						.get((String)cartMap.get("item_cd"));
				BigDecimal stockNumVal = BigDecimal.ZERO;
				BigDecimal stockThresholdNumVal = BigDecimal.ZERO;
				if (itemMap != null) {

					if (itemMap.get("stock_num") != null) {
						stockNumVal = (BigDecimal) itemMap.get("stock_num");
					}
					if (itemMap.get("stock_threshold_num") != null) {
						stockThresholdNumVal = (BigDecimal) itemMap
								.get("stock_threshold_num");
					}

					// カートからの注文時のみ
					if (isDisplay) {
					    if (itemMap.get("cart_disp_flg") != null) {
	                        if ("0".equals(itemMap.get("cart_disp_flg").toString())) {
	                            cartMap.put("item_validate", "false");
	                            itemInvalidateCheck = false;
	                        }
	                    }
					}
				}
				else {
				    if (isDisplay) {
				        itemInvalidateCheck = false;
	                    cartMap.put("item_validate", "false");
				    }
				}
				cartMap.put("stock_num", stockNumVal);
				cartMap.put("stock_threshold_num", stockThresholdNumVal);

				cartList.set(i, cartMap);
			}
		}

		// 入力値のチェック
		Map<String, Object> resultMap = order.toMap();

		resultMap.put("cart_id", order.getCartId());
		resultMap.put("quantity", order.getQuantity());
		resultMap.put("case_quantity", order.getCaseQuantity());

		result.getReturnData().put("item_invalidate_check", String.valueOf(itemInvalidateCheck));
		result.getReturnData().put("order", resultMap);

		if (!itemInvalidateCheck) {
		    result.setResultCode("error");
            result.getReturnData().put("result_code", "error");
		}

		return result;

	}
}
