package jp.ill.photon.module.cart;

import java.util.ArrayList;
import java.util.List;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

public class CheckDeliveryExistModule implements PhotonModule {

    @ModuleParam(required = true, paramGroup=true)
    private Delivery delivery = new Delivery();

    /** メッセージID（お届け先チェックエラー） */
    public static final String DELIVERY_CHECK_ERROR_MSG_ID = "orderEndErrMes5";

    public Delivery getDelivery() {
        return delivery;
    }

    public void setDelivery(Delivery delivery) {
        this.delivery = delivery;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        if (delivery.getUserDeliveryCd() == null) {
            // 自社
            result.getReturnData().put("selected_delivery", delivery.toMap());
            return result;
        } else {
            Delivery check = Delivery.getDelivery(context.getDto(), delivery.getUserDeliveryCd());
            if (check != null) {
                result.getReturnData().put("selected_delivery", delivery.toMap());
            } else {
                // お届け先が削除されている
                result.setResultCode("error");

                List<ActionDtoMessage> errorMessages = new ArrayList<ActionDtoMessage>();
                ActionDtoMessage msg = new ActionDtoMessage();
                msg.setMessageId(DELIVERY_CHECK_ERROR_MSG_ID);
				msg.setFormFieldCd("user_delivery");
                errorMessages.add(msg);
				result.getMessages().put("error_field", errorMessages);

                return result;
            }
        }

        return result;
    }

}
