package jp.ill.photon.module.cart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.message.ActionDtoMessage;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.Delivery;
import jp.ill.photon.model.Order;
import jp.ill.photon.model.SystemSetting.CaseNumDiv;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.AoUtil.FractionDiv;
import jp.ill.photon.util.JsonUtil;

@ModuleVersion("1.0.0")
public class CartUpdateModule implements PhotonModule {

	@ModuleParam(required = true, paramGroup = true)
	private Order order = new Order();

	@ModuleParam(required = true, paramGroup = true)
	private Delivery delivery = new Delivery();

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "got_session.userForm.user_cd")
	private String userCd;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "got_session_charge.userChargeForm.user_charge_id")
	private int userChargeId;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.aladdinsetting")
	private AoSetting aoSetting;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "shohin_search.list")
	private List<Map<String, Object>> itemPriceList;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.webOrderCampaignItemCd.note")
	private String webOrderCampaignCd;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.deliveryFeeItemCd.note")
	private String deliveryFeeItemCd;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.serviceChargeCd.note")
	private String chargeFeeItemCd;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.caseNumDiv.note")
	private String caseNumDiv;

	@ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "user.first")
    private Map<String, Object> userForm;

	/** メッセージID（入力値無効） */
	public static final String INPUT_ERR_NUMBER = "inputErrMesCartNumber";

	/** メッセージID（入力値無効） */
	public static final String INPUT_ERR = "inputErrMesNumber";

	private static String ERR_NUMBER_INVALID = "number invalid";

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }


	public String getCaseNumDiv() {
		return caseNumDiv;
	}

	public void setCaseNumDiv(String caseNumDiv) {
		this.caseNumDiv = caseNumDiv;
	}

	public String getWebOrderCampaignCd() {
		return webOrderCampaignCd;
	}

	public void setWebOrderCampaignCd(String webOrderCampaignCd) {
		this.webOrderCampaignCd = webOrderCampaignCd;
	}

	public String getChargeFeeItemCd() {
		return chargeFeeItemCd;
	}

	public void setChargeFeeItemCd(String chargeFeeItemCd) {
		this.chargeFeeItemCd = chargeFeeItemCd;
	}

	public String getDeliveryFeeItemCd() {
		return deliveryFeeItemCd;
	}

	public void setDeliveryFeeItemCd(String deliveryFeeItemCd) {
		this.deliveryFeeItemCd = deliveryFeeItemCd;
	}

	public List<Map<String, Object>> getItemPriceList() {
		return itemPriceList;
	}

	public void setItemPriceList(List<Map<String, Object>> itemPriceList) {
		this.itemPriceList = itemPriceList;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public Delivery getDelivery() {
		return delivery;
	}

	public void setDelivery(Delivery delivery) {
		this.delivery = delivery;
	}

	public String getUserCd() {
		return userCd;
	}

	public void setUserCd(String userCd) {
		this.userCd = userCd;
	}

	public int getUserChargeId() {
		return userChargeId;
	}

	public void setUserChargeId(int userChargeId) {
		this.userChargeId = userChargeId;
	}

	public AoSetting getAoSetting() {
		return aoSetting;
	}

	public void setAoSetting(AoSetting aoSetting) {
		this.aoSetting = aoSetting;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();
		List<ActionDtoMessage> tmpErrorMessage = new ArrayList<ActionDtoMessage>();
		Map<String, Object> retrunMessageListMap = new HashMap<String, Object>();

		// あからじめ商品情報をMapに入れておく
		Map<String, Map<String, Object>> itemPriceMap = new HashMap<String, Map<String, Object>>();
		for (Map<String, Object> map : itemPriceList) {
			if (map.get("item_cd") != null) {
				String itemCd = String.valueOf(map.get("item_cd"));

				itemPriceMap.put(itemCd, map);
			}
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		Map<String, List<String>> errorMessageListMap = new HashMap<String, List<String>>();
		Map<String, String> errorMessageMap = new HashMap<String, String>();

		if (order.getCartId().length == 0) {
			return result;
		}

		if (caseNumDiv.equals(CaseNumDiv.ON)) {
			if (order.getQuantity().length != order.getCaseQuantity().length) {
				return result;
			}
		}

		tm.required(() -> {
			for (int i = 0; i < order.getCartId().length; i++) {
				List<String> errorMessage = new ArrayList<String>();

				String cartIdStr = order.getCartId()[i];
				String itemCdStr = order.getItemCd()[i];

				if (StringUtils.isEmpty(itemCdStr)) {
					continue;
				}
				if (itemCdStr.equals(webOrderCampaignCd)
						|| itemCdStr.equals(deliveryFeeItemCd)
						|| itemCdStr.equals(chargeFeeItemCd)) {
					continue;
				}

				String quantityStr = order.getQuantity()[i];
				String caseQuantityStr = "0";
				List<Map<String, Object>> cartItem = dao.getCartByCartId(context.getDto().getTenantId(),
						cartIdStr, String.valueOf(userForm.get("user_cd")), String.valueOf(userChargeId));
				if (order.getCaseQuantity() != null
						&& order.getCaseQuantity().length >= (i + 1)) {
					caseQuantityStr = order.getCaseQuantity()[i];

					String oldValStr = String.valueOf(cartItem.get(0).get("order_case_quantity"));
					BigDecimal oldVal = new BigDecimal(oldValStr);
					BigDecimal newVal = new BigDecimal(caseQuantityStr);

					// ケースが0に変更されている場合は、ケース数を変更しない
					if (oldVal.compareTo(BigDecimal.ZERO) > 0 && newVal.compareTo(BigDecimal.ZERO) == 0) {
						caseQuantityStr = oldValStr;
					}
				}

				// 数量が0に変更されている場合は、数量を変更しない
				{
					String oldValStr = String.valueOf(cartItem.get(0).get("order_quantity"));
					BigDecimal oldVal = new BigDecimal(oldValStr);
					BigDecimal newVal = new BigDecimal(quantityStr);
					if (oldVal.compareTo(BigDecimal.ZERO) > 0 && newVal.compareTo(BigDecimal.ZERO) == 0) {
						quantityStr = oldValStr;
					}
				}

				Map<String, Object> itemMap = itemPriceMap.get(itemCdStr);

				if (itemMap == null) {
				    result.setResultCode("error");
	                result.getReturnData().put("result_code", "error");

					continue;
				}

				// 入力フォーマットチェック
				boolean[] checkResult = CartInModule.checkCartInputFormat(
						itemMap.get("price").toString(), "1",
						itemMap.get("cart_disp_flg").toString(),
						itemMap.get("quantity_per_case").toString(),
						quantityStr, caseQuantityStr, caseNumDiv, aoSetting,
						errorMessage, null, userForm);

				if (!errorMessage.isEmpty()) {
					//result.setResultCode("error");
                    //result.getReturnData().put("result_code", "error");

					if (ERR_NUMBER_INVALID.equals(errorMessage.get(0))) {
						errorMessageMap.put(itemCdStr, INPUT_ERR_NUMBER);
						addErrorMessage(errorMessageListMap, itemCdStr, errorMessage, result, tmpErrorMessage, INPUT_ERR_NUMBER);
						continue;
					} else {
						errorMessageMap.put(itemCdStr, INPUT_ERR);
						addErrorMessage(errorMessageListMap, itemCdStr, errorMessage, result, tmpErrorMessage, INPUT_ERR);
						continue;
					}
				}

				boolean orderQuantityIsBlank = checkResult[0];
				boolean orderCaseQuantityIsBlank = checkResult[1];
				boolean orderCaseQuantityFormatErr = checkResult[2];

				String quantityPerCase = AoUtil.convAoRoundingUnitQuantity(
						itemMap.get("quantity_per_case").toString(),
						AoUtil.DispPattern.PATTERN_NO_COMMA,
						aoSetting.getUnitQuantityDigitNum(),
						aoSetting.getUnitQuantityDecimalPointNum(),
						FractionDiv.DOWN);
				if (!orderCaseQuantityIsBlank) {
					quantityStr = CartInModule.quantityCalc(
							((orderCaseQuantityFormatErr) ? "1"
									: caseQuantityStr),
							quantityPerCase, aoSetting);
				}

				Map<String, Object> map = new HashMap<String, Object>();
				map.put("cart_id", cartIdStr);
				map.put("quantity_per_case", quantityPerCase);
				map.put("order_case_quantity", caseQuantityStr);
				map.put("order_quantity", quantityStr);
				map.put("wholesale_price", itemMap.get("price").toString());
				String data = JsonUtil.mapToJson(map);

				dao.updateEditTableData(context.getDto().getTenantId(), "cart",
						"system", data); // TODO 更新ユーザ
			}

		});

		retrunMessageListMap.put("error_field", tmpErrorMessage);
		result.getReturnData().put("messages", errorMessageListMap);
		result.getReturnData().put("err_messages", errorMessageMap); // 暫定
		result.setMessages(retrunMessageListMap);

		return result;
	}

	private void addErrorMessage(Map<String, List<String>> errorMessageListMap,
			String itemCdStr, List<String> errorMessage, ModuleResult result, List<ActionDtoMessage> tmpErrorMessage, String errorMsg) {
		errorMessageListMap.put(itemCdStr, errorMessage);
		result.setResultCode("error");
		result.getReturnData().put("result_code", "error");

		ActionDtoMessage dtoMessage = new ActionDtoMessage();
		dtoMessage.setFormFieldCd(itemCdStr);
		dtoMessage.setMessageId(errorMsg);
		Map<String, Object> messageMap = new HashMap<String, Object>();
		Map<String, Object> messageParamMap = new HashMap<String, Object>();
		messageParamMap.put("val", "注文数量");
		messageParamMap.put("type", "static_json");
		messageMap.put("%1$s", messageParamMap);
		dtoMessage.setParams(messageMap);
		tmpErrorMessage.add(dtoMessage);
	}

}
