package jp.ill.photon.module.cart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.builder.SimpleJSONSelectSQLBuilder;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class CartSearchModule implements PhotonModule {

	@ModuleParam(required=true)
	private Map<String, Object> user;

	@ModuleParam(required=true)
	private Map<String, Object> userCharge;

	public Map<String, Object> getUser() {
		return user;
	}

	public void setUser(Map<String, Object> user) {
		this.user = user;
	}

	public Map<String, Object> getUserCharge() {
		return userCharge;
	}

	public void setUserCharge(Map<String, Object> userCharge) {
		this.userCharge = userCharge;
	}

	@Override
	public ModuleResult execute( ModuleContext context ) {

		ModuleResult result = new ModuleResult();

		if (user == null || userCharge == null) {
			// TODO ユーザー情報が存在しない場合のエラー処理を追加する
			return result;
		}

		List<Map<String, Object>> sqlWhere = new ArrayList<>();
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "user_cd");
				put("class", String.class);
				put("value", String.valueOf(user.get("user_cd")));
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "user_charge_id");
				put("class", int.class);
				put("value", Integer.parseInt(
						String.valueOf(userCharge.get("user_charge_id"))));
			}
		});
		List<Map<String, String>> sqlOrder = new ArrayList<>();
		sqlOrder.add(new HashMap<String, String>() {
			{
				put("key", "cart_id");
				put("dr", "ASC");
			}
		});

		SimpleJSONSelectSQLBuilder builder = new SimpleJSONSelectSQLBuilder();
		List<Map<String, Object>> cart = builder
				.getListResult(context.getDto().getTenantId(), "cart", sqlWhere, sqlOrder);

		result.getReturnData().put("shohin_list", cart);

		return result;
	}

}
