package jp.ill.photon.module.cart;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.AoSetting;
import jp.ill.photon.model.CartItem;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.util.AoUtil;
import jp.ill.photon.util.UtilTools;

public class CartListModule extends SqlFileSelectModule {

	/** TODO 親クラスに書かれていれば書かなくてもいいようにしたい */
	@ModuleParam(required = true, domainObject = true)
	private SearchForm searchForm;

	@ModuleParam(required = true)
	private String sqlFileDirPath;

	@ModuleParam(required = true)
	private String sqlFilePath;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType="dto", transferVal="common.aladdinsetting")
	private AoSetting aoSetting;

	@ModuleParam(required = true)
	@DefaultParamSetting(transferType = "dto", transferVal = "user.first")
	private Map<String, Object> userForm;

    public Map<String, Object> getUserForm() {
        return userForm;
    }

    public void setUserForm(Map<String, Object> userForm) {
        this.userForm = userForm;
    }

    public AoSetting getAoSetting() {
        return aoSetting;
    }

    public void setAoSetting(AoSetting aoSetting) {
        this.aoSetting = aoSetting;
    }

    public SearchForm getSearchForm() {
		return searchForm;
	}

	public void setSearchForm(SearchForm searchForm) {
		this.searchForm = searchForm;
	}

	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	public String getSqlFilePath() {
		return sqlFilePath;
	}

	public void setSqlFilePath(String sqlFilePath) {
		this.sqlFilePath = sqlFilePath;
	}

    @Override
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {
		ModuleResult result = super.execute(context);

		// 単価を再取得して、再取得した単価に対して、金額計算、端数処理を行う。

		Map<String, Object> test = result.getReturnData();

		List<Map<String, Object>> cartList = (List<Map<String, Object>>)result.getReturnData().get("list");

		String totalRetailSalePrice = "0";
		String totalWholeSalePrice = "0";
		String totalQuantity = "0";

		List itemCdList = new ArrayList();

		//for (Map<String, Object> cartMap : cartList) {
		for (int i=0; i < cartList.size(); i++) {
		    Map<String, Object> cartMap = cartList.get(i);
			CartItem cartItem = CartItem.valueOf(cartMap);

			// 単価の再取得と変更チェックは別モジュールでやる
			BigDecimal retailSalesPrice = cartItem.getRetailSalesPriceFormat(aoSetting, userForm);
            BigDecimal subTotalPrice = cartItem.getSubTotalPriceFormat(aoSetting, userForm);

            BigDecimal stockNumVal = BigDecimal.ZERO;
			BigDecimal stockThresholdNumVal = BigDecimal.ZERO;
			if (cartMap.get("stock_num") != null) {
				stockNumVal = (BigDecimal) cartMap.get("stock_num");
			}
			if (cartMap.get("stock_threshold_num") != null) {
				stockThresholdNumVal = (BigDecimal) cartMap
						.get("stock_threshold_num");
			}
			Map<String, Object> cartMapAfter = cartItem.toMap(aoSetting, userForm);
			cartMapAfter.put("stock_num", stockNumVal);
			cartMapAfter.put("stock_threshold_num", stockThresholdNumVal);

            cartList.set(i, cartMapAfter);

			totalRetailSalePrice = UtilTools.addBigDecimal(totalRetailSalePrice, retailSalesPrice.toString());
			totalWholeSalePrice = UtilTools.addBigDecimal(totalWholeSalePrice, subTotalPrice.toString());
			totalQuantity = UtilTools.addBigDecimal(totalQuantity, cartItem.getOrderQuantity().toString());

			itemCdList.add(cartItem.getItemCd());
		}

		result.getReturnData().put("cnt", cartList.size());
		result.getReturnData().put("total_retail_sale_price", totalRetailSalePrice);
		result.getReturnData().put("total_whole_sale_price", totalWholeSalePrice);
		result.getReturnData().put("total_quantity", AoUtil.convAoRoundingSalesQuantity(totalQuantity,
		        aoSetting.getSalesQuantityDigitNum(), aoSetting.getSalesQuantityDecimalPointNum(), aoSetting.getSalesQuantityRoundingDiv()));
		result.getReturnData().put("item_cd", itemCdList);

		return result;
	}



}
