package jp.ill.photon.module.calendar;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.JsonUtil;

import org.seasar.doma.jdbc.tx.TransactionManager;

public class HolidayUpdateModule implements PhotonModule {

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param", transferVal = "year")
    private String year;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "param_multi", transferVal = "holidays")
    private String[] holidays;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "auth_user.account.admin_user_name")
    private String updateUserName;

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String[] getHolidays() {
        return holidays;
    }

    public void setHolidays(String[] holidays) {
        this.holidays = holidays;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

	@Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = new ModuleResult();

        // システム日付を取得
        Date date = new Date();
        Timestamp time = new Timestamp(date.getTime());

        /*****************************************************************
         * 更新データの設定
         *****************************************************************/

        // 開始年月日をセットする（個別）
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(year)); // 選択年
        cal.set(Calendar.MONTH, 0); // 1月
        cal.set(Calendar.DATE, 1); // 1日

        // 終了年月日をセットする（個別）
        String endDay = year + "1231";

        List<Map<String, Object>> calendarMTList = new ArrayList<Map<String, Object>>();

        String yyyymmdd;
        // 日付を1日ずつ加算していって、12/31になったら抜ける
        do {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            yyyymmdd = sdf.format(cal.getTime());

            Map<String, Object> calendar = new HashMap<String, Object>();

            // 対象日付
            calendar.put("date", yyyymmdd);
            // 曜日区分
            calendar.put("week_div", cal.get(Calendar.DAY_OF_WEEK) - 1);

            // 休日区分
            if (holidays != null && holidays.length > 0) {
                for (int i = 0; i < holidays.length; i++) {
                    if (yyyymmdd.equals(holidays[i])) {
                        calendar.put("holiday_div", 1);
                        break;
                    } else {
                        calendar.put("holiday_div", 0);
                    }
                }
            }

            calendarMTList.add(calendar);

            // 1日進める
            cal.add(Calendar.DAY_OF_MONTH, 1);

        } while (yyyymmdd.compareTo(endDay) < 0);

        TransactionManager tm = DomaConfig.singleton().getTransactionManager();
        JsonDataDao dao = new JsonDataDaoImpl();

        tm.required(() -> {

            // 始めに対象年のデータを削除
            dao.deleteCalendarByYear(context.getDto().getTenantId(), year);

            // 対象年のデータをinsert
            for (Map<String, Object> c : calendarMTList) {
                String data = JsonUtil.mapToJson(c);
                dao.insertEditTableData(context.getDto().getTenantId(), "calendar", updateUserName, data);
            }

        });

        return result;
    }

}
