package jp.ill.photon.module.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.util.CheckUtil;

import org.apache.commons.lang.StringUtils;

public class HolidaySettingModule extends SqlFileSelectModule {

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.calendarYearPulldown.note")
    private String calendarYearPulldown;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "year")
    private String year;

    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }

    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    public String getSqlFilePath() {
        return sqlFilePath;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public String getCalendarYearPulldown() {
        return calendarYearPulldown;
    }

    public void setCalendarYearPulldown(String calendarYearPulldown) {
        this.calendarYearPulldown = calendarYearPulldown;
    }

    @Override
    public ModuleResult execute(ModuleContext context)
            throws PhotonModuleException {

        // 年リスト設定
        int minYear = Calendar.getInstance().get(Calendar.YEAR);
        int maxYear = minYear + Integer.parseInt(calendarYearPulldown);

        List<String> yearList = new ArrayList<String>();

        for (int i = minYear; i <= maxYear; i++) {
            yearList.add(String.valueOf(i));
        }

        // 選択年設定(年の範囲外の場合は最小の年に合わせる)
        if (StringUtils.isEmpty(this.year)
                || !CheckUtil.isRange(this.year, minYear, maxYear)) {
            this.year = String.valueOf(minYear);
        }

        ModuleResult result = super.execute(context);

        List<Map<String, Object>> holidayList = (List<Map<String, Object>>)result.getReturnData().get("list");
        Map<String, Map<String, Object>> holidayMap = new HashMap<String, Map<String, Object>>();
        // あらかじめMapに詰めておく
        for (int i = 0; i < holidayList.size(); i++) {
            Map<String, Object> holiday = holidayList.get(i);
            holidayMap.put(String.valueOf(holiday.get("date")), holiday);
        }

        List<List<List<Map<String, Object>>>> monthList = new ArrayList<List<List<Map<String, Object>>>>();
        for (int i = 1; i <= 12; i++) {
            List<List<Map<String, Object>>> monthInfo = getMonthCalendar(Integer.parseInt(year), i, holidayMap);

            monthList.add(monthInfo);

        }

        result.getReturnData().put("month_list", monthList);
        result.getReturnData().put("year_list", yearList);
        result.getReturnData().put("year", year);

        return result;
    }

    /**
     * 1月当たりのカレンダー情報取得
     *
     * @param year 年
     * @param month 月
     * @param holidayList 休業日リスト
     * @param weekForm 休業曜日情報
     * @return HolidayForm[][]
     */
    private List<List<Map<String, Object>>> getMonthCalendar(int year, int month, Map<String, Map<String, Object>> holidayMap) {

        // 一月分の空データ
        List<List<Map<String, Object>>> calendarMatrix = new ArrayList<List<Map<String, Object>>>();
        for (int i = 0; i < 6; i++) {
            List<Map<String, Object>> week = new ArrayList<Map<String, Object>>();
            for (int j = 0; j < 7; j++) {
                week.add(new HashMap<String, Object>());
            }

            calendarMatrix.add(week);
        }

        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        // 月の初めの曜日を求めます。
        calendar.set(year, month - 1, 1); // 引数: 1月: 0, 2月: 1, ... ;
        int startDay = calendar.get(Calendar.DAY_OF_WEEK);
        // 月末の日付を求めます。
        calendar.add(Calendar.MONTH, 1);
        calendar.add(Calendar.DATE, -1);
        int lastDate = calendar.get(Calendar.DATE);
        // カレンダー表を作成します。
        int row = 0;
        int column = startDay - 1; // startDay: 日曜日 = 1, 月曜日 = 2, ...
        Calendar cal = Calendar.getInstance();
        for (int date = 1; date <= lastDate; date++) {
            cal.set(year, month - 1, date);
            Map holiday = new HashMap<String, Object>();
            holiday.put("year", String.valueOf(year));
            holiday.put("month", String.valueOf(month));
            holiday.put("day", String.valueOf(date));
            holiday.put("week_div", String.valueOf(cal.get(Calendar.DAY_OF_WEEK) - 1)); // 0が日曜日、1が月曜日 ... 6が土曜日

            String dayString = String.format("%04d", year) + String.format("%02d", month) + String.format("%02d", date);
            holiday.put("date", dayString);

            if (holidayMap.containsKey(dayString)) {
                holiday.put("holiday_div", 1);
            } else {
                holiday.put("holiday_div", 0);
            }

            // 休業曜日の設定
            holiday.put("week_day", "true"); // TODO

//            if (weekForm != null) {
//                switch (column) {
//                case 0:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getSundayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 1:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getMondayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 2:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getTuesdayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 3:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getWednesdayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 4:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getThursdayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 5:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getFridayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                case 6:
//                    if (DefineManager.Const.HolidayDiv.HOLIDAY.equals(weekForm
//                            .getSaturdayHolidayDiv())) {
//                        holiday.setWeekday(true);
//                    }
//                    break;
//                default:
//                    break;
//                }
//            }

            calendarMatrix.get(row).set(column, holiday);
            if (column == 6) {
                row++;
                column = 0;
            } else {
                column++;
            }
        }
        return calendarMatrix;
    }

}
