package jp.ill.photon.module.cache;

import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CacheUtil;
import redis.clients.jedis.Jedis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@ModuleVersion("1.0.0")
public class CacheStoreModule implements PhotonModule {

	@ModuleParam(required=true)
	private Map<String, Object> cacheKeys;

	@ModuleParam(required=true)
	private boolean cacheExist;

	@ModuleParam(required=true)
	private List<Map<String, Object>> list;

    public Map<String, Object> getCacheKeys() {
		return cacheKeys;
	}

	public void setCacheKeys(Map<String, Object> cacheKeys) {
		this.cacheKeys = cacheKeys;
	}

	public boolean isCacheExist() {
		return cacheExist;
	}

	public void setCacheExist(boolean cacheExist) {
		this.cacheExist = cacheExist;
	}

	public List<Map<String, Object>> getList() {
		return list;
	}

	public void setList(List<Map<String, Object>> list) {
		this.list = list;
	}

	@Override
    public ModuleResult execute( ModuleContext context ) {
        ModuleResult result = new ModuleResult();

        // キャッシュがないときだけキャッシュをセット
        if (!Boolean.valueOf(cacheExist) && list != null) {
            String key = CacheUtil.getCacheKeyJsonString(cacheKeys, context.getDto());

            Jedis jedis = null;
            try {
                jedis = new Jedis("localhost");

                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString(list);
                jedis.set(key, json);

            } catch (JsonProcessingException ex) {
                // TODO log
            } finally {
                jedis.close();
            }
        }

        return result;
    }
}
