package jp.ill.photon.module.cache;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleReturn;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CacheUtil;
import jp.ill.photon.util.ParamUtil;
import redis.clients.jedis.Jedis;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@ModuleVersion("1.0.0")
public class CacheCheckModule implements PhotonModule {

    @ModuleParam(required=true)
    private Map<String, Object> refTables;

    @ModuleParam(required=true)
    @ModuleReturn()
    private Map<String, Object> cacheKeys;

    @ModuleReturn()
    private boolean isCacheExist;

    public Map<String, Object> getRefTables() {
        return refTables;
    }

    public void setRefTables(Map<String, Object> refTables) {
        this.refTables = refTables;
    }

    public Map<String, Object> getCacheKeys() {
        return cacheKeys;
    }

    public void setCacheKeys(Map<String, Object> cacheKeys) {
        this.cacheKeys = cacheKeys;
    }

    public boolean isCacheExist() {
        return isCacheExist;
    }

    public void setCacheExist(boolean isCacheExist) {
        this.isCacheExist = isCacheExist;
    }

    @Override
    public ModuleResult execute( ModuleContext context ) {
        ModuleResult result = new ModuleResult();

        isCacheExist = false;

        // refTablesの更新日時チェック
        if (isRefTableUpdate(refTables)) {
            // TODO 参照テーブルのキャッシュを削除
            isCacheExist = false;
        } else {
            // cache_keysを元にキャッシュを探索
            String cache = getCacheAsString(cacheKeys, context.getDto());

            if (cache != null && !"".equals(cache)) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    List<Map<String, Object>> cacheValue = (List<Map<String, Object>>)mapper.readValue(cache, List.class);
                    isCacheExist = true;

                    result.getReturnData().put("list", cacheValue);
                } catch (JsonMappingException ex) {
                } catch (JsonParseException ex) {
                } catch (IOException ex) {
                }
            }
        }

        // キャッシュキーをDTOのパラメータとしてセットし直す
        for (String key : cacheKeys.keySet()) {
            Object obj = ParamUtil.getParamValueByType(
					String.valueOf(((Map) cacheKeys.get(key)).get("transfer_type")),
					((Map) cacheKeys.get(key))
							.get("transfer_val"),
							context.getDto());
            result.getReturnData().put(key, obj);
        }

        result.getReturnData().put("cache_exist", isCacheExist);
        result.getReturnData().put("cache_keys", cacheKeys);

        return result;
    }

    private String getCacheAsString(Map<String, Object> cacheKeys, ActionDto dto) {

        String key = CacheUtil.getCacheKeyJsonString(cacheKeys, dto);

        //System.out.println(key);

        Jedis jedis = null;
        try {
            jedis = new Jedis("localhost");
            String value = jedis.get(key);

            if (value == null || "".equals(value)) {
                return null;
            } else {
                return value;
            }
        } finally {
            jedis.close();
        }
    }

    // TODO 未実装
    private boolean isRefTableUpdate(Map<String, Object> refTables) {
        return false;
    }

}
