package jp.ill.photon.module.bill;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.Bill;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class BillListModule implements PhotonModule {

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.billFileDir.note")
    private String billFileBasePath;

    // デフォルト値は、ここで設定する
    @ModuleParam(required=true, domainObject=true)
    private User user = null;

    @ModuleParam(required=false)
    private int pageNo = 1;

    @ModuleParam(required=true)
    private int pageCount = 5;

    @ModuleParam(required=false)
    private int sortNo = 1;

    public int getSortNo() {
        return sortNo;
    }

    public void setSortNo(int sortNo) {
        this.sortNo = sortNo;
    }

    public String getBillFileBasePath() {
        return billFileBasePath;
    }

    public void setBillFileBasePath(String billFileBasePath) {
        this.billFileBasePath = billFileBasePath;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getPageNo() {
        return pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageCount() {
        return pageCount;
    }

    public void setPageCount(int maxPageCount) {
        this.pageCount = maxPageCount;
    }

    @Override
    public ModuleResult execute( ModuleContext context ) throws PhotonModuleException {

        ModuleResult result = new ModuleResult();

        if (user == null) {
        	throw new PhotonModuleException("User is not authorized.", null);
        } else {
            String userCd = user.getUserCd();

            List<Map<String, Object>> billList = getBillList(billFileBasePath, userCd, pageNo, pageCount);

            result.getReturnData().put("list", billList);
            result.getReturnData().put("count", count);

            return result;
        }
    }

    private int count;

    /**
     * 請求書一覧 取得
     *
     * @param pageNo ページ番号
     * @param maxPageCount 1ページに表示する件数
     * @return List<ItemForm> 商品情報リスト
     */
    public List<Map<String, Object>> getBillList(  String rootPath, String userCd,
                                            int pageNo,
                                            int maxPageCount) {

        // 戻り値格納用
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>();

        // 開始行
        int rowNo = (pageNo - 1) * maxPageCount;

        // 画像一覧取得
        // ルートパスを取得
        Path root = Paths.get(rootPath);
        Path userRoot = root.resolve(userCd);

        File dir = userRoot.toFile();

        count = 0;
        if (!dir.exists()) {
            count = 0;
        } else {
            File[] files = dir.listFiles();

            if (files != null) {

                if (sortNo == 1) {
                    java.util.Arrays.sort(files, new java.util.Comparator<File>() {
                        public int compare(File file1, File file2){
                            return file1.getName().compareTo(file2.getName());
                        }
                    });
                } else {
                    java.util.Arrays.sort(files, new java.util.Comparator<File>() {
                        public int compare(File file1, File file2){
                            return file2.getName().compareTo(file1.getName());
                        }
                    });
                }

                for (int i = 0; i < files.length; i++) {
                    if (rowNo <= i && i < (rowNo + maxPageCount)) {
                        Bill bill = new Bill(files[i]);
                        Map<String, Object> result = bill.toMap();
                        results.add(result);
                    }
                }
            }

            if (files != null && files.length > 0) {
                count = files.length;
            }
        }

        return results;
    }

}
