package jp.ill.photon.module.bill;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.Bill;
import jp.ill.photon.model.User;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

@ModuleVersion("1.0.0")
public class BillDownloadModule implements PhotonModule {

	// デフォルト値は、ここで設定する
    @ModuleParam(required=true, domainObject=true)
    private User user = null;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.billFileDir.note")
    private String billFileBasePath;

    @ModuleParam(required=true)
    private String encodedFileName;

	public String getBillFileBasePath() {
        return billFileBasePath;
    }

    public void setBillFileBasePath(String billFileBasePath) {
        this.billFileBasePath = billFileBasePath;
    }

    public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public String getEncodedFileName() {
		return encodedFileName;
	}

	public void setEncodedFileName(String encodedFileName) {
		this.encodedFileName = encodedFileName;
	}

	@Override
	public ModuleResult execute( ModuleContext context ) throws PhotonModuleException {

		ModuleResult result = new ModuleResult();
		try {
	        if (user == null) {
	            throw new PhotonModuleException("User is not authorized.", null);
	        } else {
	            String userCd = user.getUserCd();
	            String decodedFileName = URLDecoder.decode(encodedFileName, "UTF-8");

	            String billFilePath = Bill.getBillFilePath(userCd, decodedFileName, billFileBasePath);

	            result.getReturnData().put("file_path", billFilePath);

	            return result;
	        }
		} catch (UnsupportedEncodingException ex) {
			throw new PhotonModuleException("Unexpected error.", ex);
		}
	}
}
