package jp.ill.photon.module.banner;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.jdbc.command.DeleteCommand;
import org.seasar.doma.jdbc.command.InsertCommand;
import org.seasar.doma.jdbc.command.SelectCommand;
import org.seasar.doma.jdbc.command.UpdateCommand;
import org.seasar.doma.jdbc.query.DeleteQuery;
import org.seasar.doma.jdbc.query.InsertQuery;
import org.seasar.doma.jdbc.query.SelectQuery;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.action.ActionParamMap;
import jp.ill.photon.action.FileParam;
import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.doma.SqlDeleteQueryFactory;
import jp.ill.photon.doma.SqlInsertQueryFactory;
import jp.ill.photon.doma.SqlSelectQueryFactory;
import jp.ill.photon.doma.SqlUpdateQueryFactory;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.Banner;
import jp.ill.photon.model.FileForm;
import jp.ill.photon.model.Publishing;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.module.file.FileCopyModule;
import jp.ill.photon.module.file.FileDeleteModule;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.SQLUtil;
import jp.ill.photon.util.StringUtil;
import jp.ill.photon.util.UtilTools;


public class BannerUpdateModule implements PhotonModule {

	@ModuleParam(required = true)
	private Map<String, Object> paramJson;

	@ModuleParam(required = true)
	private String execType;

	@ModuleParam(required = false)
	private List<FileForm> fileForms;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.exSqlFileDir.note")
	private String sqlFileDirPath;

	@ModuleParam(required = false)
	@DefaultParamSetting(transferType = "dto", transferVal = "common.systemsetting.bannerImageDir.note")
	private String bannerImageDir;

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public ModuleResult execute(ModuleContext context)
			throws PhotonModuleException {

		ActionDto dto = context.getDto();
		ActionParamMap paramMap = dto.getParams();
		ModuleResult moduleResult = new ModuleResult();

		JsonDataDao dao = new JsonDataDaoImpl();

		Map<String, Object> common = (Map<String, Object>) dto.getDataMap().get("common");
		Map<String, Object> systemSettingMap = (Map<String, Object>) common.get("systemsetting");

		Map<String, Object> params = new LinkedHashMap<String, Object>();
		// 入力値をマップにする
		if (paramJson != null) {
			Map<String, String> paramInfo = null;
			for (Map.Entry<String, Object> input : paramJson.entrySet()) {
				paramInfo = (Map) input.getValue();
				params.put(input.getKey(), ParamUtil.getParamValueByType(
						paramInfo.get("type"), paramInfo.get("val"), dto));
			}
		}
		// JSON形式で登録できるようにエスケープ
		for(Entry<String, Object> entry: params.entrySet()){
			String key = entry.getKey();
			params.put(key, StringUtil.escapeJsonStr((String) params.get(key)));
		}

		// 新規登録かどうか
		boolean isNewRegist = false;

		// 登録/変更日時
		String nowDatetime = SQLUtil.getNowDatetime();
		String loginUserName = SQLUtil.getLoginAdminUserName(dto);

		// テナントID
		String tenantId = paramMap.get("_init.tenant_id");
		// バナーID
		String bannerId = paramMap.get("bannerInfo.bannerId");
		// バナーIDが未設定の場合は新規採番
		if(UtilTools.isEmpty(bannerId)){

			// 新規登録
			isNewRegist = true;

/*			TransactionManager tm = DomaConfig.singleton().getTransactionManager();
			SqlSelectQueryFactory selectFactory = SqlSelectQueryFactory.newInstance();

			*//** バナーID新規採番 *//*
			HashMap<String, Object> bannerIdNexValParams = SQLUtil.createBannerIdNextValParams(tenantId);
			SqlSelectQuery getNextBannerIdQuery = selectFactory.createSelectQueryFromFile(
					bannerIdNexValParams, context.getDto(),
					sqlFileDirPath, "aec20/banner/getBannerIdNextVal.sql");
			getNextBannerIdQuery.prepare();

			List<Map<String, Object>> bannerIdNextValMap = tm.required(() -> {
				SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
						getNextBannerIdQuery,
						new MapResultListHandler(MapKeyNamingType.NONE));
				return command.execute();
			});
			bannerId = StringUtil.defaultString(bannerIdNextValMap.get(0).get("banner_id"));*/


			TransactionManager tm = DomaConfig.singleton().getTransactionManager();

			// シーケンス使用可能フラグ
			boolean isFree = false;

			while(!isFree){

				isFree = true;
				// NewsNoの採番と採番テーブルの更新
	            List<Map<String, Object>> seqMap = dao.getSeqSfNextVal(tenantId, "banner", "banner_id");
	            if (seqMap == null || seqMap.isEmpty()) {
	            	moduleResult.setResultType(ModuleResult.ResultTypes.ERROR);
	                return moduleResult;
	            }

	            bannerId = StringUtil.defaultString(String.valueOf(seqMap.get(0).get("seq")));

	            SqlSelectQueryFactory  seleteFactory = SqlSelectQueryFactory.newInstance();
				HashMap<String, Object> selectBannerInfoParamMap = new HashMap<String, Object>();
				selectBannerInfoParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
				selectBannerInfoParamMap.put("bannerId", SQLUtil.toSubMap(StringUtil.defaultString(bannerId)));
				SelectQuery seleteBannerInfoQuery = seleteFactory.createSelectQueryFromFile(
						selectBannerInfoParamMap, context.getDto(),
						sqlFileDirPath, "aec20/banner/selectBannerInfoByBannerId.sql");
				seleteBannerInfoQuery.prepare();

				// シーケンスから取得されたバナーIDの存在チェックを行う
				List<Map<String, Object>> bannerInfo = tm.required(() -> {
					SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
							seleteBannerInfoQuery,new MapResultListHandler(MapKeyNamingType.NONE));
					return command.execute();
				});

	            if(!bannerInfo.isEmpty()){
	            	isFree = false;
	            }
			}
		}

		// お知らせ公開先テーブル
		List<Publishing> bannerPublishingList = new ArrayList<Publishing>();
		// 選択した得意先分類1
		String[] selectedUserCategories1 = paramMap.getValues("bannerInfo.selectedUserCategories1");
		int rowNum = 1;
		if (selectedUserCategories1 != null && selectedUserCategories1.length > 0) {
			for (String userCategory : selectedUserCategories1) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(bannerId, 0));
				publishing.setUserCategoryNum(Integer
						.parseInt(UserCategoryNum.USER_CATEGORY_1));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				bannerPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先分類2
		String[] selectedUserCategories2 = paramMap.getValues("bannerInfo.selectedUserCategories2");
		rowNum = 1;
		if (selectedUserCategories2 != null && selectedUserCategories2.length > 0) {
			for (String userCategory : selectedUserCategories2) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(bannerId, 0));
				publishing.setUserCategoryNum(Integer
						.parseInt(UserCategoryNum.USER_CATEGORY_2));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				bannerPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先分類3
		String[] selectedUserCategories3 = paramMap.getValues("bannerInfo.selectedUserCategories3");
		rowNum = 1;
		if (selectedUserCategories3 != null && selectedUserCategories3.length > 0) {
			for (String userCategory : selectedUserCategories3) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(bannerId, 0));
				publishing.setUserCategoryNum(Integer
						.parseInt(UserCategoryNum.USER_CATEGORY_3));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCategoryCd(userCategory);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				bannerPublishingList.add(publishing);
				rowNum++;
			}
		}

		// 選択した得意先
		String[] selectedUsers = paramMap.getValues("bannerInfo.selectedUsers");
		rowNum = 1;
		if (selectedUsers != null && selectedUsers.length > 0) {
			for (String user : selectedUsers) {

				Publishing publishing = new Publishing();
				publishing.setId(StringUtil.toInteger(bannerId, 0));
				publishing.setUserCategoryNum(Integer
						.parseInt(UserCategoryNum.USER));
				publishing.setUserCategoryNumRen(rowNum);
				publishing.setUserCd(user);
				publishing.setUpdateUserName(loginUserName);
				publishing.setUpdateDatetime(nowDatetime);
				publishing.setUpdateDiv(1);
				publishing.setInsertUserName(loginUserName);
				publishing.setInsertDatetime(nowDatetime);
				publishing.setInsertDiv(1);
				bannerPublishingList.add(publishing);
				rowNum++;
			}
		}

		String commonBannerImageDir = (String)((Map<String, Object>) systemSettingMap.get("bannerImageDir")).get("note");
		String imagePath = (String) params.get("imagePath");
		String imageDelFlg = (String) params.get("imageDelFlg");

		/** バナー画像のファイル操作 */
		String imageFileName = "";
		if(!UtilTools.isEmpty(imagePath)){
			// 画像ファイル名を設定 (バナーID + 拡張子)
			imageFileName = bannerId + "." + getSuffix(imagePath);
		}
		if(imageDelFlg != null && "1".equals(imageDelFlg)){
			// バナー画像の削除
			params.put("imagePath", "");

			if(!UtilTools.isEmpty(commonBannerImageDir) && !UtilTools.isEmpty(imageFileName)){
				FileDeleteModule filedeleteModule = new FileDeleteModule();
				filedeleteModule.setDirPath(commonBannerImageDir);
				filedeleteModule.setFileName(imageFileName);
				filedeleteModule.execute(context);
			}

		}else{

			if(!UtilTools.isEmpty(imageFileName)){

				// バナー画像のアップロード
				FileParam bannerImageParam = dto.getParams().getFile("bannerInfo.bannerImage");
				if(bannerImageParam != null){
					File bannerImage = bannerImageParam.getFile();

					if(bannerImage != null && !UtilTools.isEmpty(commonBannerImageDir)){
						FileCopyModule fileCopyModule = new FileCopyModule();
						fileCopyModule.setSrcFilePath(bannerImage.getPath());
						fileCopyModule.setDestDirPath(commonBannerImageDir);
						fileCopyModule.setDestFilePath(imageFileName);
						fileCopyModule.execute(context);
					}
				}
			}
		}

		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		Banner banner = new Banner();
		try {
			ConvertUtils.register(new BigDecimalConverter(null), BigDecimal.class);
			BeanUtils.copyProperties(banner, params);
			ConvertUtils.deregister();
		} catch (Exception e) {
			e.printStackTrace();
		}

		int result;

		/** 新規登録 or 更新 */
		if ("insert".equals(execType) || "update".equals(execType)) {
			String startDate = (String) params.get("startDate");
			String startDateTime = (String) params.get("startDateTime");
			String endDate = (String) params.get("endDate");
			String endDateTime = (String) params.get("endDateTime");
			banner.setStartDate(startDate + " " + startDateTime);
			banner.setEndDate(endDate + " " + endDateTime);
			banner.setBannerImage(imageFileName);

			banner.setUpdateDatetime(nowDatetime);
			banner.setUpdateUserName(loginUserName);
			banner.setUpdateDiv(1);
			banner.setInsertDatetime(nowDatetime);
			banner.setInsertUserName(loginUserName);
			banner.setInsertDiv(1);

			if(isNewRegist){
				banner.setBannerId(StringUtil.toInteger(bannerId));

				/** バナーマスタに新規登録 */
				SqlInsertQueryFactory insertFactory = SqlInsertQueryFactory.newInstance();
				HashMap<String, Object> insertBannerInfoParamMap = SQLUtil.createBannerInfoParams(tenantId, banner, isNewRegist);
				InsertQuery insertBannerInfoQuery = insertFactory.createInsertQueryFromFile(
						insertBannerInfoParamMap, context.getDto(),
						sqlFileDirPath, "aec20/banner/insertBannerInfo.sql");
				insertBannerInfoQuery.prepare();

				// 登録処理を実行
				result = tm.required(() -> {
					InsertCommand command = new InsertCommand(
							insertBannerInfoQuery);
					return command.execute();
				});

			}else{
				/** バナーマスタの更新 */
				SqlUpdateQueryFactory updateFactory = SqlUpdateQueryFactory.newInstance();
				HashMap<String, Object> updateBannerInfoParamMap = SQLUtil.createBannerInfoParams(tenantId, banner, isNewRegist);
				UpdateQuery updateBannerInfoQuery = updateFactory.createUpdateQueryFromFile(
						updateBannerInfoParamMap, context.getDto(),
						sqlFileDirPath, "aec20/banner/updateBannerInfo.sql");
				updateBannerInfoQuery.prepare();

				// 更新処理を実行
				result = tm.required(() -> {
					UpdateCommand command = new UpdateCommand(
							updateBannerInfoQuery);
					return command.execute();
				});
			}

			/** バナー公開先削除 */
			SqlDeleteQueryFactory  deleteFactory = SqlDeleteQueryFactory.newInstance();
			HashMap<String, Object> deleteBannerPubParamMap = new HashMap<String, Object>();
			deleteBannerPubParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
			deleteBannerPubParamMap.put("procDiv", SQLUtil.toSubMap("banner"));
			deleteBannerPubParamMap.put("bannerId", SQLUtil.toSubMap(StringUtil.defaultString(banner.getBannerId())));
			DeleteQuery deleteBannerPubQuery = deleteFactory.createDeleteQueryFromFile(
					deleteBannerPubParamMap, context.getDto(),
					sqlFileDirPath, "aec20/publish/deletePublishById.sql");
			deleteBannerPubQuery.prepare();

			// 削除処理を実行
			result = tm.required(() -> {
				DeleteCommand command = new DeleteCommand(
						deleteBannerPubQuery);
				return command.execute();
			});

			/** バナー公開先登録 */
			SqlInsertQueryFactory  insertFactory = SqlInsertQueryFactory.newInstance();
			for (Publishing bannerPub : bannerPublishingList) {
				HashMap<String, Object> insertBannerPubParamMap = SQLUtil.createInsertPubParams(tenantId, bannerPub, "banner");
				InsertQuery insertBannerPubQuery = insertFactory.createInsertQueryFromFile(
						insertBannerPubParamMap, context.getDto(),
						sqlFileDirPath, "aec20/publish/insertPublishById.sql");
				insertBannerPubQuery.prepare();

				// 登録処理を実行
				result = (int) tm.required(() -> {
					InsertCommand command = new InsertCommand(
							insertBannerPubQuery);
					return command.execute();
				});
			}

		/** 削除 */
		} else if ("delete".equals(execType)) {

			/** バナーマスタの削除 */
			SqlSelectQueryFactory  deleteFactory = SqlSelectQueryFactory.newInstance();
			HashMap<String, Object> deleteBannerInfoParamMap = new HashMap<String, Object>();
			deleteBannerInfoParamMap.put("tenantId", SQLUtil.toSubMap(tenantId));
			deleteBannerInfoParamMap.put("bannerId", SQLUtil.toSubMap(StringUtil.defaultString(banner.getBannerId())));
			SelectQuery deleteBannerInfoQuery = deleteFactory.createSelectQueryFromFile(
					deleteBannerInfoParamMap, context.getDto(),
					sqlFileDirPath, "aec20/banner/deleteBannerInfo.sql");
			deleteBannerInfoQuery.prepare();

			// 削除処理を実行
			tm.required(() -> {
				SelectCommand<List<Map<String, Object>>> command = new SelectCommand<>(
						deleteBannerInfoQuery,new MapResultListHandler(MapKeyNamingType.NONE));
				return command.execute();
			});
		}

		return moduleResult;
	}

	/** お知らせ公開先 - 得意先分類番号 */
	public static class UserCategoryNum {
		/** 得意先分類1 */
		public static final String USER_CATEGORY_1 = "1";
		/** 得意先分類2 */
		public static final String USER_CATEGORY_2 = "2";
		/** 得意先分類3 */
		public static final String USER_CATEGORY_3 = "3";
		/** 得意先 */
		public static final String USER = "4";
	}

	/**
	 * ファイル名から拡張子を返します。
	 *
	 * @param fileName ファイル名
	 * @return ファイルの拡張子
	 */
	private String getSuffix(String fileName) {
		if (fileName == null) {
			return null;
		}
		int point = fileName.lastIndexOf(".");
		if (point != -1) {
			return fileName.substring(point + 1);
		}
		return fileName;
	}

	/**
	 * paramJsonを取得します。
	 * @return paramJson
	 */
	public Map<String, Object> getParamJson() {
		return paramJson;
	}

	/**
	 * paramJsonを設定します。
	 * @param paramJson
	 */
	public void setParamJson(Map<String, Object> paramJson) {
		this.paramJson = paramJson;
	}

	/**
	 * fileFormsを取得します。
	 * @return fileForms
	 */
	public List<FileForm> getFileForms() {
		return fileForms;
	}

	/**
	 * fileFormsを設定します。
	 * @param fileForms
	 */
	public void setFileForms(List<FileForm> fileForms) {
		this.fileForms = fileForms;
	}

	/**
	 * sqlFileDirPathを取得します。
	 * @return sqlFileDirPath
	 */
	public String getSqlFileDirPath() {
		return sqlFileDirPath;
	}

	/**
	 * sqlFileDirPathを設定します。
	 * @param sqlFileDirPath
	 */
	public void setSqlFileDirPath(String sqlFileDirPath) {
		this.sqlFileDirPath = sqlFileDirPath;
	}

	/**
	 * bannerImageDirを取得します。
	 * @return bannerImageDir
	 */
	public String getBannerImageDir() {
		return bannerImageDir;
	}

	/**
	 * bannerImageDirを設定します。
	 * @param bannerImageDir
	 */
	public void setBannerImageDir(String bannerImageDir) {
		this.bannerImageDir = bannerImageDir;
	}

	/**
	 * execTypeを取得します。
	 * @return execType
	 */
	public String getExecType() {
		return execType;
	}

	/**
	 * execTypeを設定します。
	 * @param execType
	 */
	public void setExecType(String execType) {
		this.execType = execType;
	}

}
