package jp.ill.photon.module.banner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.model.SearchForm;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.db.SqlFileSelectModule;
import jp.ill.photon.util.JsonUtil;

public class BannerDetailModule extends SqlFileSelectModule {

    @ModuleParam(required = true, domainObject = true)
    private SearchForm searchForm;

    @ModuleParam(required = true)
    private String sqlFileDirPath;

    @ModuleParam(required = true)
    private String sqlFilePath;

    @ModuleParam(required = false)
    @DefaultParamSetting(transferType = "param", transferVal = "banner_id")
    private String bannerId;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category1_list.list")
    private List<Map<String, Object>> publishedUserCategory1List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category2_list.list")
    private List<Map<String, Object>> publishedUserCategory2List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_category3_list.list")
    private List<Map<String, Object>> publishedUserCategory3List;

    @ModuleParam(required = true)
    @DefaultParamSetting(transferType = "dto", transferVal = "published_user_list.list")
    private List<Map<String, Object>> publishedUserList;

    public SearchForm getSearchForm() {
        return searchForm;
    }

    public void setSearchForm(SearchForm searchForm) {
        this.searchForm = searchForm;
    }

    public String getSqlFileDirPath() {
        return sqlFileDirPath;
    }

    public void setSqlFileDirPath(String sqlFileDirPath) {
        this.sqlFileDirPath = sqlFileDirPath;
    }

    public String getSqlFilePath() {
        return sqlFilePath;
    }

    public void setSqlFilePath(String sqlFilePath) {
        this.sqlFilePath = sqlFilePath;
    }

    public String getBannerId() {
        return bannerId;
    }

    public void setBannerId(String bannerId) {
        this.bannerId = bannerId;
    }

    public List<Map<String, Object>> getPublishedUserCategory1List() {
        return publishedUserCategory1List;
    }

    public void setPublishedUserCategory1List(List<Map<String, Object>> publishedUserCategory1List) {
        this.publishedUserCategory1List = publishedUserCategory1List;
    }

    public List<Map<String, Object>> getPublishedUserCategory2List() {
        return publishedUserCategory2List;
    }

    public void setPublishedUserCategory2List(List<Map<String, Object>> publishedUserCategory2List) {
        this.publishedUserCategory2List = publishedUserCategory2List;
    }

    public List<Map<String, Object>> getPublishedUserCategory3List() {
        return publishedUserCategory3List;
    }

    public void setPublishedUserCategory3List(List<Map<String, Object>> publishedUserCategory3List) {
        this.publishedUserCategory3List = publishedUserCategory3List;
    }

    public List<Map<String, Object>> getPublishedUserList() {
        return publishedUserList;
    }

    public void setPublishedUserList(List<Map<String, Object>> publishedUserList) {
        this.publishedUserList = publishedUserList;
    }

    @Override
    public ModuleResult execute(ModuleContext context) throws PhotonModuleException {
        ModuleResult result = super.execute(context);

        @SuppressWarnings("unchecked")
		Map<String, Object> bannerInfo = (Map<String, Object>) result.getReturnData().get("first");

        Map<String, Object> bannerMap = new HashMap<String, Object>();

        if(bannerInfo != null){
	        String bannerId = (String) bannerInfo.get("banner_id");
	        bannerMap.put("banner_id", bannerId);
	        bannerMap.put("banner_name", bannerInfo.get("banner_name"));
	        bannerMap.put("banner_image", bannerInfo.get("banner_image"));
	        bannerMap.put("banner_alt", bannerInfo.get("banner_alt"));
	        bannerMap.put("banner_url", bannerInfo.get("banner_url"));
			bannerMap.put("start_date", bannerInfo.get("start_date"));
			bannerMap.put("start_datetime", bannerInfo.get("start_datetime"));
			bannerMap.put("end_date", bannerInfo.get("end_date"));
			bannerMap.put("end_datetime", bannerInfo.get("end_datetime"));
			bannerMap.put("disp_flg", bannerInfo.get("disp_flg"));
			bannerMap.put("sort_no", bannerInfo.get("sort_no"));
			bannerMap.put("disp_div", bannerInfo.get("disp_div"));
			bannerMap.put("user_category1_disp_div", bannerInfo.get("user_category1_disp_div"));
			bannerMap.put("user_category2_disp_div", bannerInfo.get("user_category2_disp_div"));
			bannerMap.put("user_category3_disp_div", bannerInfo.get("user_category3_disp_div"));
			bannerMap.put("user_disp_div", bannerInfo.get("user_disp_div"));

			// 公開先得意先分類リスト
			bannerMap.put("published_user_category1_list_json", JsonUtil.mapToJson(getPublishedUserCategory1List()));
			bannerMap.put("published_user_category2_list_json", JsonUtil.mapToJson(getPublishedUserCategory2List()));
			bannerMap.put("published_user_category3_list_json", JsonUtil.mapToJson(getPublishedUserCategory3List()));
			// 公開先得意先リスト
			bannerMap.put("published_user_list_json", JsonUtil.mapToJson(getPublishedUserList()));

        }else{

        	// 新規登録デフォルト値
        	bannerMap.put("disp_flg", "1");
        	bannerMap.put("disp_div", "1");
        }

        result.setReturnData(bannerMap);

        return result;
    }

}
