package jp.ill.photon.module.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.builder.JSONDomaSQLQueryBuilder;
import jp.ill.photon.dao.builder.SimpleJSONSelectSQLBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;

@ModuleVersion("1.0.0")
public class UserChargeLoginModule implements PhotonModule {

	@ModuleParam(required = false)
	private String sessionKeyUserCharge = "aec_user_charge";

	@ModuleParam(required = false)
	private String sessionKeyUser = "aec_user";

	@ModuleParam(required = false)
	private String loginId = "";

	@ModuleParam(required = false)
	private String loginPw = "";

	@ModuleParam(required = false)
	private String encryptKey = "";

	@ModuleParam(required = false)
	private String userCd = "";

	@ModuleParam(required = false)
	private String userChargeId = "";

	@ModuleParam(required = false)
	private String sessionKeyAction = "login_after_action";

	public String getSessionKeyAction() {
		return sessionKeyAction;
	}

	public void setSessionKeyAction(String sessionKeyAction) {
		this.sessionKeyAction = sessionKeyAction;
	}

	public String getSessionKeyUserCharge() {
		return sessionKeyUserCharge;
	}

	public void setSessionKeyUserCharge(String sessionKeyUserCharge) {
		this.sessionKeyUserCharge = sessionKeyUserCharge;
	}

	public String getSessionKeyUser() {
		return sessionKeyUser;
	}

	public void setSessionKeyUser(String sessionKeyUser) {
		this.sessionKeyUser = sessionKeyUser;
	}

	public String getLoginId() {
		return loginId;
	}

	public void setLoginId(String loginId) {
		this.loginId = loginId;
	}

	public String getLoginPw() {
		return loginPw;
	}

	public void setLoginPw(String loginPw) {
		this.loginPw = loginPw;
	}

	public String getEncryptKey() {
		return encryptKey;
	}

	public void setEncryptKey(String encryptKey) {
		this.encryptKey = encryptKey;
	}

	public String getUserCd() {
		return userCd;
	}

	public void setUserCd(String userCd) {
		this.userCd = userCd;
	}

	public String getUserChargeId() {
		return userChargeId;
	}

	public void setUserChargeId(String userChargeId) {
		this.userChargeId = userChargeId;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {
		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		if (!userCd.isEmpty()) {
			result = executeUserSelect(sessionKeyUserCharge, sessionKeyUser,
					context.getDto(), userCd, session);
		} else if (!userChargeId.isEmpty()) {
			result = executeShowUserSelect(context.getDto(), userChargeId,
					sessionKeyUser, session);
		} else if (!loginId.equals("") && !loginPw.equals("")) {
			result = executeAuthUserCharge(loginId, loginPw, encryptKey,
					session, sessionKeyUser, sessionKeyUserCharge,
					context.getDto());
		} else {
			result = executeShowUserLogin();
		}

		return result;
	}

	/**
	 * 得意先選択後処理
	 *
	 * @param sessionKeyUserCharge
	 * @param sessionKeyUser
	 * @param dto
	 * @param userCd
	 * @param session
	 * @return
	 */
	protected ModuleResult executeUserSelect(	String sessionKeyUserCharge,
												String sessionKeyUser,
												ActionDto dto,
												String userCd,
												HttpSession session) {
		ModuleResult result = new ModuleResult();

		Map<String, Object> userCharge = (Map<String, Object>) session
				.getAttribute(sessionKeyUserCharge);
		if (userCharge != null) {
			Map<String, Object> user = getUser(dto, userCd);
			session.setAttribute(sessionKeyUser, user);
			result.getReturnData().put("user", user);

			result.setResultCode("auth_success");
			result.setResultType(ModuleResult.ResultTypes.REDIRECT);
			String loginAfterAction = getLoginAfterAction(session, dto);
			result.setNextPath(loginAfterAction);
			return result;
		}

		return result;
	}

	/**
	 * 得意先選択用得意先一覧取得処理
	 *
	 * @param dto
	 * @param userChargeId
	 * @return
	 */
	protected ModuleResult executeShowUserSelect(	ActionDto dto,
													String userChargeId,
													String sessionKeyUser,
													HttpSession session) {
		ModuleResult result = new ModuleResult();
		Map<String, Object> userCharge = getUserCharge(dto, userChargeId);

		List<Map<String, Object>> userList = null;

		if (userCharge != null) {
			userList = getUserRelList(dto, Integer.parseInt(
					String.valueOf(userCharge.get("user_charge_id"))));
		}

		result.getReturnData().put("user_list", userList);
		result.setResultCode("auth_success_multi");
		result.setResultType(ModuleResult.ResultTypes.CONTINUE);
		return result;
	}

	/**
	 * 担当者認証処理
	 *
	 * @param loginId
	 * @param loginPw
	 * @param encryptKey
	 * @param session
	 * @param sessionKeyUserCharge
	 * @param dto
	 * @return
	 */
	protected ModuleResult executeAuthUserCharge(	String loginId,
													String loginPw,
													String encryptKey,
													HttpSession session,
													String sessionKeyUser,
													String sessionKeyUserCharge,
													ActionDto dto) {
		ModuleResult result = new ModuleResult();
		Map<String, Object> userCharge = null;
		String encryptedPassword = CryptUtil.digestPassword(loginPw,
				encryptKey);
		userCharge = authUserCharge(dto, loginId, encryptedPassword);

		List<Map<String, Object>> userList = null;
		if (userCharge != null) {
			userList = getUserRelList(dto, Integer.parseInt(
					String.valueOf(userCharge.get("user_charge_id"))));
		}

		if (userCharge == null || userList == null || userList.size() == 0) {
			result.setResultCode("auth_failed");
			return result;
		}

		session.setAttribute(sessionKeyUserCharge, userCharge);
		result.getReturnData().put("user_charge", userCharge);

		if (userList.size() == 1) {
			Map<String, Object> user = userList.get(0);
			session.setAttribute(sessionKeyUser, user);
			result.getReturnData().put("user", user);

			result.setResultCode("auth_success");
			result.setResultType(ModuleResult.ResultTypes.REDIRECT);

			result.setNextPath((String) dto.getAction().get("url_root") + "/");

		} else if (userList.size() > 1) {
			result.setResultCode("auth_success_multi");
			result.setResultType(ModuleResult.ResultTypes.FORWARD);
			result.setNextPath(
					(String) dto.getAction().get("url_root") + "/select_user");
		}
		return result;

	}

	protected String getLoginAfterAction(HttpSession session, ActionDto dto) {
		String loginAfterAction = (String) session
				.getAttribute(sessionKeyAction);

		if (loginAfterAction == null) {
			return (String) dto.getAction().get("url_root") + "/";
		} else {
			return loginAfterAction;
		}
	}

	/**
	 * ログインフォーム表示処理
	 *
	 * @return
	 */
	protected ModuleResult executeShowUserLogin() {
		ModuleResult result = new ModuleResult();

		return result;
	}

	protected Map<String, Object> getUser(ActionDto dto, String userCd) {
		StringBuffer query = new StringBuffer();
		query.append("SELECT ");
		query.append("tbu.val ");
		query.append("FROM entity_data tbu ");
		query.append("WHERE tbu.tenant_id = {#tenant_id, text, action#} ");
		query.append("AND tbu.edit_table_cd = 'user' ");
		query.append("AND tbu.val->>'user_cd' = {#user_cd, text, param#} ");
		query.append("AND tbu.val->>'delete_flg' = {#0, text#} ");

		Map<String, Object> params = new HashMap<>();
		params.put("user_cd", userCd);

		JSONDomaSQLQueryBuilder queryBuilder = new JSONDomaSQLQueryBuilder();
		Map<String, Object> user = queryBuilder.getFirstResult(query.toString(),
				params, dto);
		return user;
	}

	protected List<Map<String, Object>> getUserRelList(	ActionDto dto,
														int userChargeId) {

		StringBuffer query = new StringBuffer();
		query.append("SELECT ");
		query.append("tbu.val ");
		query.append("FROM entity_data tbucr ");
		query.append(
				"LEFT JOIN entity_data tbu ON tbu.tenant_id = {#tenant_id, text, action#} AND tbu.edit_table_cd = 'user' AND tbu.val->>'user_cd' = tbucr.val->>'user_cd' ");
		query.append("WHERE tbucr.tenant_id = {#tenant_id, text, action#} ");
		query.append("AND tbucr.edit_table_cd = 'userchargerel' ");
		query.append(
				"AND tbucr.val->>'user_charge_id' = {#user_charge_id, text, param#} ");
		query.append("AND tbu.val->>'delete_flg' = {#0, text#} ");
		query.append("ORDER BY tbucr.val->>'user_cd'");

		Map<String, Object> params = new HashMap<>();
		params.put("user_charge_id", userChargeId);

		JSONDomaSQLQueryBuilder queryBuilder = new JSONDomaSQLQueryBuilder();
		List<Map<String, Object>> userList = queryBuilder
				.getListResult(query.toString(), params, dto);
		return userList;
	}

	protected Map<String, Object> authUserCharge(	ActionDto dto,
													String id,
													String pw) {

		List<Map<String, Object>> sqlWhere = new ArrayList<>();
		List<Map<String, String>> sqlOrder = new ArrayList<>();
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "login_id");
				put("class", String.class);
				put("value", id);
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "login_pw");
				put("class", String.class);
				put("value", pw);
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "disp_flg");
				put("class", String.class);
				put("value", "1");
			}
		});

		SimpleJSONSelectSQLBuilder builder = new SimpleJSONSelectSQLBuilder();
		Map<String, Object> user = builder.getFirstResult(dto.getTenantId(),
				"usercharge", sqlWhere, sqlOrder);

		return user;
	}

	protected Map<String, Object> getUserCharge(ActionDto dto,
												String userChargeId) {

		List<Map<String, Object>> sqlWhere = new ArrayList<>();
		List<Map<String, String>> sqlOrder = new ArrayList<>();
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "user_charge_id");
				put("class", String.class);
				put("value", userChargeId);
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "disp_flg");
				put("class", String.class);
				put("value", "1");
			}
		});

		SimpleJSONSelectSQLBuilder builder = new SimpleJSONSelectSQLBuilder();
		Map<String, Object> user = builder.getFirstResult(dto.getTenantId(),
				"usercharge", sqlWhere, sqlOrder);

		return user;
	}

}
