package jp.ill.photon.module.auth;

import java.util.Map;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;

/**
 * ユーザーがログインしているかどうかをチェックし、ログイン済みならログイン情報をセッションから取得する
 *
 * @author h_tanaka
 *
 */
@ModuleVersion("1.0.0")
public class LoginCheckModule implements PhotonModule {

	@ModuleParam(required=false)
	private String sessionKeyUser = "aec_user";

	@ModuleParam(required=false)
	private String sessionKeyUserCharge = "aec_user_charge";

	@ModuleParam(required=false)
	private String sessionKeyAction = "login_after_action";

	@ModuleParam(required=false)
	private String sessionKeyParams = "login_after_params";

	public String getSessionKeyUser() {
		return sessionKeyUser;
	}

	public void setSessionKeyUser(String sessionKeyUser) {
		this.sessionKeyUser = sessionKeyUser;
	}

	public String getSessionKeyUserCharge() {
		return sessionKeyUserCharge;
	}

	public void setSessionKeyUserCharge(String sessionKeyUserCharge) {
		this.sessionKeyUserCharge = sessionKeyUserCharge;
	}

	public String getSessionKeyAction() {
		return sessionKeyAction;
	}

	public void setSessionKeyAction(String sessionKeyAction) {
		this.sessionKeyAction = sessionKeyAction;
	}

	public String getSessionKeyParams() {
		return sessionKeyParams;
	}

	public void setSessionKeyParams(String sessionKeyParams) {
		this.sessionKeyParams = sessionKeyParams;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();

		HttpSession session = context.getDto().getSession();
		// TODO 暫定
		// String urlRoot = ((String) context.getDto().getAction().get("url_root")).substring("/aec".length());
		String urlRoot = (String) context.getDto().getAction().get("url_root");
		String requestUrl = (String) context.getDto().getParams().get("_init.url");
		String requestAction = requestUrl.substring(requestUrl.indexOf(urlRoot));

		if (session.isNew()) {
			session.setAttribute(sessionKeyAction, requestAction);
			session.setAttribute(sessionKeyParams, context.getDto().getParams());
			result.getReturnData().put("is_logged_in", false);
			result.setResultCode("check_failed");
			result.setResultType(ModuleResult.ResultTypes.REDIRECT);
			return result;
		}

		Map<String, Object> user = (Map<String, Object>) session
				.getAttribute(sessionKeyUser);
		Map<String, Object> userCharge = (Map<String, Object>) session
				.getAttribute(sessionKeyUserCharge);

		if (user == null) {
			session.setAttribute(sessionKeyAction, requestAction);
			session.setAttribute(sessionKeyParams, context.getDto().getParams());
			result.getReturnData().put("is_logged_in", false);
			result.setResultCode("check_failed");
			result.setResultType(ModuleResult.ResultTypes.REDIRECT);
		} else {
			result.getReturnData().put("is_logged_in", true);
			result.getReturnData().put("user", user);
			result.getReturnData().put("user_charge", userCharge);
			result.setResultCode("check_success");
		}

		return result;
	}
}
