package jp.ill.photon.module.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.builder.SimpleJSONSelectSQLBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;

@ModuleVersion("1.0.0")
public class AdminLoginModule implements PhotonModule {

	@ModuleParam(required=false)
	private String sessionKeyUser = "aec_user";

	@ModuleParam(required=false)
	private String loginId = "";

	@ModuleParam(required=false)
	private String loginPw = "";

	@ModuleParam(required=false)
	private String encryptKey = "";

	public String getSessionKeyUser() {
		return sessionKeyUser;
	}

	public void setSessionKeyUser(String sessionKeyUser) {
		this.sessionKeyUser = sessionKeyUser;
	}

	public String getLoginId() {
		return loginId;
	}

	public void setLoginId(String loginId) {
		this.loginId = loginId;
	}

	public String getLoginPw() {
		return loginPw;
	}

	public void setLoginPw(String loginPw) {
		this.loginPw = loginPw;
	}

	public String getEncryptKey() {
		return encryptKey;
	}

	public void setEncryptKey(String encryptKey) {
		this.encryptKey = encryptKey;
	}

	@Override
	public ModuleResult execute(ModuleContext context) {

		Map<String, Object> user = null;
		if (!loginId.equals("") && !loginPw.equals("")) {
			String encryptedPassword = CryptUtil.digestPassword(loginPw,
					encryptKey);
			user = authUser(context.getDto(), loginId, encryptedPassword);
		}

		ModuleResult result = new ModuleResult();
		HttpSession session = context.getDto().getSession();

		if (user != null) {
			session.setAttribute(sessionKeyUser, user);
			result.getReturnData().put("is_logged_in", true);
			result.getReturnData().put("user", user);

			result.setResultCode("auth_success");
			result.setResultType(ModuleResult.ResultTypes.REDIRECT);
			result.setNextPath((String) context.getDto().getAction().get("url_root") + "/");
		} else {
			result.getReturnData().put("is_logged_in", false);
		}

		return result;
	}

	protected Map<String, Object> authUser(	ActionDto dto,
											String id,
											String pw) {

		List<Map<String, Object>> sqlWhere = new ArrayList<>();
		List<Map<String, String>> sqlOrder = new ArrayList<>();
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "login_id");
				put("class", String.class);
				put("value", id);
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "login_pw");
				put("class", String.class);
				put("value", pw);
			}
		});
		sqlWhere.add(new HashMap<String, Object>() {
			{
				put("name", "invalid_flg");
				put("class", String.class);
				put("value", "0");
			}
		});

		SimpleJSONSelectSQLBuilder builder = new SimpleJSONSelectSQLBuilder();
		Map<String, Object> user = builder.getFirstResult(dto.getTenantId(),
				"adminuser", sqlWhere, sqlOrder);

		return user;
	}

	@Override
	public String getModuleVersion() {
		return "1.0.0";
	}
}
