package jp.ill.photon.module.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.postgresql.util.PGobject;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.dao.JsonDataDaoImpl;
import jp.ill.photon.dao.MetaObjectDao;
import jp.ill.photon.dao.MetaObjectDaoImpl;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.module.ModuleResult;
import jp.ill.photon.module.PhotonModule;
import jp.ill.photon.util.CryptUtil;
import jp.ill.photon.util.JsonUtil;
import jp.ill.photon.util.ParamUtil;
import jp.ill.photon.util.ParamUtil.TransferTypes;

/**
 * API認証処理モジュール
 *
 * @author j_nakai
 *
 */
@ModuleVersion("1.0.0")
public class ApiCertifyModule implements PhotonModule {

	@SuppressWarnings("unchecked")
	@Override
	public ModuleResult execute(ModuleContext context) {

		ModuleResult result = new ModuleResult();

		// TODO 汎用化のためにパラメータとして対象テーブルを受け取れるようにする
		List<String> targetTables = Arrays.asList("systemsetting", "mesg",
				"aladdinsetting", "label");
		List<String> horizontalTables = Arrays.asList("label");

		Map<String, String> keyColumnMap = getKeyColumns(
				context.getDto().getTenantId(), targetTables);
		List<Map<String, Object>> settings = getSettings(
				context.getDto().getTenantId(), targetTables);

		String editTableCd = null;
		Map<String, Object> tableSetting = null;
		Map<String, Object> jsonValue = null;
		for (Map<String, Object> setting : settings) {
			editTableCd = (String) setting.get("edit_table_cd");
			tableSetting = (result.getReturnData().containsKey(editTableCd))
					? (Map<String, Object>) result.getReturnData()
							.get(editTableCd)
					: new LinkedHashMap<>();
			jsonValue = JsonUtil
					.jsonToMap(((PGobject) setting.get("val")).getValue());
			if (horizontalTables.contains(editTableCd)) {
				for (Map.Entry<String, Object> row : jsonValue.entrySet()) {
					tableSetting.put(row.getKey(), row.getValue());
				}
			} else {
				tableSetting.put(
						String.valueOf(
								jsonValue.get(keyColumnMap.get(editTableCd))),
						jsonValue);
			}
			result.getReturnData().put(editTableCd, tableSetting);
		}

		// 設定コンバート
		Map<String, Object> settingParams = (Map<String, Object>) result
				.getReturnData().get("systemsetting");

		boolean is_user_logged_in = false;
		if (context.getDto().containsKey("auth.is_logged_in")) {
			is_user_logged_in = (boolean) context.getDto()
					.get("auth.is_logged_in");
		}

		String stockDispFlg = (is_user_logged_in)
				? String.valueOf(settingParams.get("stockDispFlg"))
				: String.valueOf(settingParams.get("noLoginStockDispFlg"));
		settingParams.put("stockDispFlg", stockDispFlg);

		result.getReturnData().put("systemsetting", settingParams);

		// システム設定内のAPI認証キーを設定しているID名
		final String SYSTEM_SETTING_ID = "authenticationKey";
		// システム設定内のAPI認証キーを設定しているカラム名
		final String SYSTEM_SETTING_VALUE_CALAM = "note";
		// URLから来る暗号化値の設定名
		final String MD5_SPLITER_STR = "signing";

		// システム設定からAPI認証キーのデータを取得
		List<Map<String, Object>> systemSettingValDataList = getSystemSettingValData(
				context.getDto().getTenantId(), SYSTEM_SETTING_ID);
		List<Map<String, Object>> systemSettingDataList = new ArrayList<Map<String, Object>>();
		Map<String, Object> jsonValueMap = null;
		// JSON形式のAPI認証キーデータをMAPに格納
		for (Map<String, Object> systemSettingValDataMap : systemSettingValDataList) {
			jsonValueMap = JsonUtil.jsonToMap(
					((PGobject) systemSettingValDataMap.get("val")).getValue());
			systemSettingDataList.add(jsonValueMap);
		}
		// API認証キーはシステム設定テーブルでは1データしかない想定なので、それ以外の場合はエラーとする
		if (systemSettingDataList.size() != 1) {
			// エラー処理(システム設定テーブルでのAPI認証キーが１データ以外なのでエラー)
			result.setResultCode("error_systemSetting_data");
			result.setResultType(ModuleResult.ResultTypes.BREAK);
			result.setNextPath(
					(String) context.getDto().getAction().get("url_root")
							+ "/");
		}
		// API認証キーの取得
		String apiAuthenticationKey = (String) systemSettingDataList.get(0)
				.get(SYSTEM_SETTING_VALUE_CALAM);

		// URLを取得
		Map<String, Object> parameters = context.getDto().getRawParams();
		Map<String, String> paramMap = new HashMap<String, String>();
		for (String keyString : parameters.keySet()) {
			paramMap.put(keyString,
					(String) ParamUtil.getParamValueByType(TransferTypes.PARAM,
							keyString, context.getDto()));
		}

		// キーのリストを作る
		List<String> keylist = new ArrayList<String>(paramMap.keySet());
		// Comparator でキーを降順ソート
		Collections.sort(keylist, new Comparator<String>() {
			// 比較関数
			@Override
			public int compare(String o1, String o2) {
				return o1.compareTo(o2);
			}
		});

		/* LISTからKEYのパラメータを取得する場合 開始 */
		if (keylist != null && keylist.size() != 0) {

			// ｍｄ５で暗号化文言を作ります
			StringBuffer requestParamBuffer = new StringBuffer();
			for (String keyString : keylist) {
				// md5暗号化部分は含めない
				if (!MD5_SPLITER_STR.equals(keyString)) {
					requestParamBuffer.append(
							keyString + "=" + paramMap.get(keyString) + "&");
				}
			}
			String requestParam = new String();
			if (requestParamBuffer.length() != 0) {
				// 最後の「&」を削除してString型に格納
				requestParam = requestParamBuffer.substring(0,
						requestParamBuffer.length() - 1);
			}
			// パラメータのｍｄ５文言を取得
			String paramMd5Value = (String) context.getDto().getParams()
					.getSingleValueParams().get(MD5_SPLITER_STR);

			// ｍｄ５の部分が正しいか確認します
			String confMd5Value = CryptUtil
					.createMd5Utf(requestParam + apiAuthenticationKey);
			// ｍｄ５部分が間違っている場合
			if (paramMd5Value == null || ("").equals(paramMd5Value)
					|| !confMd5Value.equals(paramMd5Value)) {
				// API認証エラー処理
				result.setResultCode("error_authentication");
				result.setResultType(ModuleResult.ResultTypes.BREAK);
				result.setNextPath(
						(String) context.getDto().getAction().get("url_root")
								+ "/");
			} else {
				// API認証成功
				result.setResultCode("success");
				result.setResultType(ModuleResult.ResultTypes.CONTINUE);
				result.setNextPath(
						(String) context.getDto().getAction().get("url_root")
								+ "/");
			}
		}

		/* LISTからKEYのパラメータを取得する場合 終了 */

		/* DTOからKEYのパラメータを取得する場合 開始 */
		/*
		 * if(paramMap!=null && paramMap.size()!=0){ // ｍｄ５で暗号化文言を作ります
		 * StringBuffer requestParamBuffer = new StringBuffer(); for(String
		 * keyString : paramMap.keySet()){ // md5暗号化部分は含めない
		 * if(!md5SpliterStr.equals(keyString)){
		 * requestParamBuffer.append(keyString + "=" + paramMap.get(keyString) +
		 * "&"); } } String requestParam = new String();
		 * if(requestParamBuffer.length()!=0){ // 最後の「&」を削除してString型に格納
		 * requestParam = requestParamBuffer.substring(0,
		 * requestParamBuffer.length()-1); } // パラメータのｍｄ５文言を取得 String
		 * paramMd5Value =
		 * (String)context.getDto().getParams().getSingleValueParams().get(
		 * md5SpliterStr); // ｍｄ５の部分が正しいか確認します String confMd5Value =
		 * CryptUtil.createMd5Sjis(requestParam + apiAuthenticationKey); //
		 * ｍｄ５部分が間違っている場合 if(paramMd5Value==null || ("").equals(paramMd5Value)
		 * || !confMd5Value.equals(paramMd5Value)){ // API認証エラー処理
		 * System.out.println("API認証エラー"); }else{
		 * System.out.println("API認証成功！！"); } }
		 */

		/* DTOのパラメータからKEYのパラメータを取得する場合 終了 */

		/* URLのパラメータからKEYのパラメータを取得する場合 開始 */
		/*
		 * int questionIndex = requestURL.indexOf(paramSpliterStr); int
		 * signingIndex = requestURL.indexOf("&"+ md5SpliterStr +"=");
		 * if(questionIndex==-1 || signingIndex==-1){ // APIのURL構文エラー処理
		 * System.out.println("APIのURL構文エラー"); }else{ //
		 * URLのリクエストパラメータと、ｍｄ５で暗号化したパラメータを分離させます String requestParam =
		 * requestURL.substring(questionIndex+1, signingIndex); String
		 * paramMd5Value = requestURL.substring(signingIndex+("&"+ md5SpliterStr
		 * +"=").length()); // ｍｄ５の部分が正しいか確認します String confMd5Value =
		 * CryptUtil.createMd5Sjis(requestParam + apiAuthenticationKey); //
		 * ｍｄ５部分が間違っている場合 if(paramMd5Value==null || ("").equals(paramMd5Value)
		 * || !confMd5Value.equals(paramMd5Value)){ // API認証エラー処理
		 * System.out.println("API認証エラー"); }else{
		 * System.out.println("API認証成功！！"); } }
		 */
		/* URLのパラメータからKEYのパラメータを取得する場合 終了 */

		return result;
	}

	/**
	 * システム設定データを指定したテナントIDと、システム設定IDで取得する
	 *
	 * @param tenantId テナントID
	 * @param systemSettingId システム設定ID
	 * @return システム設定データリスト
	 */
	protected List<Map<String, Object>> getSystemSettingValData(String tenantId,
																String systemSettingId) {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> settings = tm.required(() -> {
			return dao.selectSystemSettingValData(tenantId, systemSettingId);
		});

		return settings;
	}

	/**
	 * テーブルごとのキー列情報を取得する。複合キーはdot区切りで結合する
	 *
	 * @param targetTables
	 * @return
	 */
	protected Map<String, String> getKeyColumns(String tenantId,
												List<String> targetTables) {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		MetaObjectDao metaDao = new MetaObjectDaoImpl();

		List<Map<String, Object>> keyColumns = tm.required(() -> {
			return metaDao.selectTableKeyColumns(tenantId, targetTables);
		});

		Map<String, String> keyColumnMap = new HashMap<String, String>();
		for (Map<String, Object> keyColumn : keyColumns) {
			keyColumnMap.put((String) keyColumn.get("edit_table_cd"),
					(String) keyColumn.get("key_column"));
		}

		return keyColumnMap;
	}

	/**
	 * 指定したテーブルのデータを一括取得する
	 *
	 * @param tenantId
	 * @param targetTables
	 * @return
	 */
	protected List<Map<String, Object>> getSettings(String tenantId,
													List<String> targetTables) {
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();
		JsonDataDao dao = new JsonDataDaoImpl();

		List<Map<String, Object>> settings = tm.required(() -> {
			return dao.selectSettings(tenantId, targetTables);
		});

		return settings;
	}
}