package jp.ill.photon.module;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.ill.photon.annotation.ModuleParam;
import jp.ill.photon.annotation.ModuleReturn;
import jp.ill.photon.annotation.ModuleVersion;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.exception.PhotonModuleException;
import jp.ill.photon.exception.PhotonPageNotFoundException;
import jp.ill.photon.util.JudgeExecutableModuleUtil;
import jp.ill.photon.util.ParamUtil;

/**
 * AEC2.0のモジュール用インターフェース
 *
 * @author h_tanaka
 *
 */
public interface PhotonModule {

	public static final class ModuleTypes {
		public static final int ACTION = 1;
		public static final int OUTPUT = 2;
		public static final int VALIDATION = 3;
	}

	/**
	 * モジュールが実行可能かを判定<br />
	 * falseだとモジュールの実行をスキップする
	 *
	 * @param コンテキスト
	 * @param モジュールパラメータ
	 *
	 * @return
	 */
	@SuppressWarnings("unchecked")
	default boolean isExecutable(	ModuleContext context,
									Map<String, Object> moduleParamSettings) {

		boolean ret = true;

		String condFieldName = "*check_cond_layout*";
		String targetFieldName = "*check_target_values*";
		ActionDto dto = context.getDto();

		if (moduleParamSettings.containsKey(condFieldName)) {

			Map<String, Object> condMap = (Map<String, Object>) moduleParamSettings
					.get(condFieldName);
			String cond = (String) ParamUtil.getParamValueByType(
					(String) condMap.get("transfer_type"),
					condMap.get("transfer_val"), dto);

			Map<String, Object> targetMap = (Map<String, Object>) moduleParamSettings
					.get(targetFieldName);
			Map<String, Object> target = (Map<String, Object>) ParamUtil
					.getParamValueByType(
							(String) targetMap.get("transfer_type"),
							targetMap.get("transfer_val"), dto);

			ret = JudgeExecutableModuleUtil.isExecutable(cond, target, dto);

		}

		return ret;

	}

	/**
	 * モジュールのバージョン番号を返す
	 *
	 * @return
	 */
	default String getModuleVersion() {
		ModuleVersion version = this.getClass()
				.getAnnotation(ModuleVersion.class);
		if (version != null) {
			return version.value();
		} else {
			return "";
		}
	}

	/**
	 * モジュールのパラメータ情報を返す
	 *
	 * @return
	 */
	default List<Map<String, String>> getParamInfo() {

		List<Map<String, String>> result = new ArrayList<Map<String, String>>();

		Field[] fs = this.getClass().getDeclaredFields();
		for (Field f : fs) {

			Map<String, String> map = new HashMap<String, String>();

			ModuleParam param = f.getAnnotation(ModuleParam.class);
			if (param != null) {
				// map.put("description", param.description());
				map.put("required", String.valueOf(param.required()));
				result.add(map);
			}
		}

		return result;
	}

	/**
	 * モジュールの返り値情報を返す
	 *
	 * @return
	 */
	default List<Map<String, String>> getReturnInfo() {
		List<Map<String, String>> result = new ArrayList<Map<String, String>>();

		Field[] fs = this.getClass().getDeclaredFields();
		for (Field f : fs) {

			Map<String, String> map = new HashMap<String, String>();

			ModuleReturn ret = f.getAnnotation(ModuleReturn.class);
			if (ret != null) {
				map.put("description", ret.description());
				result.add(map);
			}
		}

		return result;
	}

	/**
	 * モジュールのメイン処理を実行する
	 *
	 * @param params
	 * @return
	 */
	// ModuleResult execute(Map<String, Object> moduleParams, ActionDto dto);
	ModuleResult execute(ModuleContext context)
			throws PhotonModuleException, PhotonPageNotFoundException;

	/**
	 * パラメータの値を取得
	 *
	 * @param map
	 * @param key
	 * @param def
	 * @return
	 */
	default Object getParamValue(	Map<String, Object> map,
									String key,
									Object def) {
		if (map.containsKey(key) && map.get(key) != null
				&& !map.get(key).equals("")) {
			return map.get(key);
		} else {
			return def;
		}
	}
}
