package jp.ill.photon.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.message.ActionDtoMessage;

public class ModuleResult {

	public static class ResultTypes {
		public static final String CONTINUE = "continue";
		public static final String BREAK = "break";
		public static final String FORWARD = "forward";
		public static final String REDIRECT = "redirect";
		public static final String ERROR = "error";
	}

	public ModuleResult() {
		this.resultCode = "success";
		this.resultType = ResultTypes.CONTINUE;
		this.messages = new HashMap<String, Object>(){{
			put("info_page", new ArrayList<ActionDtoMessage>());
			put("info_field", new ArrayList<ActionDtoMessage>());
			put("error_page", new ArrayList<ActionDtoMessage>());
			put("error_field", new ArrayList<ActionDtoMessage>());
		}};
	}

	public Map<String, Object> getReturnData() {
		if (returnData == null) {
			returnData = new LinkedHashMap<String, Object>();
		}
		return returnData;
	}

	public void setReturnData(Map<String, Object> returnData) {
		this.returnData = returnData;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getResultType() {
		return resultType;
	}

	public void setResultType(String resultType) {
		this.resultType = resultType;
	}

	public String getNextPath() {
		return nextPath;
	}

	public void setNextPath(String nextPath) {
		this.nextPath = nextPath;
	}

	public Map<String, Object> getMessages() {
		return messages;
	}

	public void setMessages(Map<String, Object> messages) {
		this.messages = messages;
	}

	/** モジュールの出力データ */
	private Map<String, Object> returnData;
	/** モジュールの処理結果コード */
	private String resultCode;
	/** モジュールのデフォルト処理結果タイプ(アクションで変更可能) */
	private String resultType;
	/** モジュールのデフォルトリダイレクト/フォワード先(アクションで変更可能) */
	private String nextPath;
	/** 生成したメッセージのマップ */
	private Map<String, Object> messages;
}
