package jp.ill.photon.module;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.postgresql.util.PGobject;
import org.seasar.doma.jdbc.tx.TransactionManager;

import jp.ill.photon.dao.DomaConfig;
import jp.ill.photon.dao.MetaObjectDao;
import jp.ill.photon.dao.MetaObjectDaoImpl;
import jp.ill.photon.util.JsonUtil;

public class ModuleRepository {

	public static ModuleRepository newInstance() {
		return new ModuleRepository();
	}

	/**
	 * 指定したモジュールIDを持つモジュールのマップ（キーはmodule_id）を取得する。
	 * 
	 * @param moduleIdList
	 * @return
	 */
	public Map<String, Object> getModuleSettings(List<String> moduleIdList) {
		MetaObjectDao dao = new MetaObjectDaoImpl();
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();

		List<Map<String, Object>> moduleList = tm.required(() -> {
			return dao.selectModuleByModuleIdList(moduleIdList);
		});

		Map<String, Object> modules = moduleList.stream().collect(
				Collectors.toMap(s -> (String) s.get("module_id"), s -> s));

		return modules;
	}

	/**
	 * 指定したバリデーションセットIDを持つバリデーションセットのマップ(キーはvalidation_set_id)を取得する。
	 * 
	 * @param tenantId
	 * @param validationSetIdList
	 * @return
	 */
	public Map<String, Object> getValidationSetSettings(String tenantId,
														List<String> validationSetIdList) {
		MetaObjectDao dao = new MetaObjectDaoImpl();
		TransactionManager tm = DomaConfig.singleton().getTransactionManager();

		List<Map<String, Object>> validationSetList = tm.required(() -> {
			return dao.selectValidationSetByIdList(tenantId,
					validationSetIdList);
		});

		Map<String, Object> jsonValue = null;
		for (Map<String, Object> row : validationSetList) {
			jsonValue = JsonUtil
					.jsonToMap(((PGobject) row.get("validations")).getValue());
			row.put("validations", jsonValue);
		}

		Map<String, Object> validationSetMap = validationSetList.stream()
				.collect(Collectors.toMap(
						s -> (String) s.get("validation_set_id"), s -> s));

		return validationSetMap;
	}
}
