package jp.ill.photon.module;

/**
 * AEC2.0モジュールを生成するファクトリクラス
 * 
 * @author h_tanaka
 *
 */
public class ModuleFactory {

	/**
	 * 指定されたパスのAECモジュールを生成して返すメソッド
	 * 
	 * @param classPath
	 * @return
	 */
	public static PhotonModule get(String classPath) {
		Class<?> clazz = null;
		try {
			clazz = Class.forName(classPath);
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}

		if (clazz == null) {
			return null;
		}

		PhotonModule ins = null;
		try {
			ins = (PhotonModule) clazz.newInstance();
		} catch (InstantiationException | IllegalAccessException e) {
			e.printStackTrace();
		}

		return ins;
	}
}
