package jp.ill.photon.module;

import java.util.Map;

import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.util.StringUtil;

public class ModuleContext {

	private ActionDto dto;
	private Map<String, Object> actionModule;

	/** アクションモジュールID （デバッグ用プロパティ） */
	private String actionModuleId;

	/** アクションモジュールの実行順 （デバッグ用プロパティ） */
	private String mindex;

	public ModuleContext(ActionDto dto) {
		this.dto = dto;
	}

	public ModuleContext(ActionDto dto, Map<String, Object> actionModule) {
		this.dto = dto;
		this.actionModule = actionModule;

		if (actionModule != null) {
			if (actionModule.containsKey("action_module_id")) {
				actionModuleId = StringUtil.defaultString(
						actionModule.get("action_module_id"), "");
			}
			if (actionModule.containsKey("mindex")) {
				mindex = StringUtil.defaultString(actionModule.get("mindex"),
						"");
			}
		}
	}

	public ActionDto getDto() {
		return dto;
	}

	public Map<String, Object> getActionModule() {
		return actionModule;
	}
}
