package jp.ill.photon.model;

import java.util.HashMap;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.dao.builder.JSONDomaSQLQueryBuilder;
import jp.ill.photon.dto.ActionDto;
import jp.ill.photon.util.StringUtil;

public class User {

    private String userCd;

    private String userCategory1Cd;
    private String userCategory2Cd;
    private String userCategory3Cd;
    private String userName1;
    private String userName2;
    private String userNameKana;
    private String bossName;
    private String zip;
    private String cityName1;
    private String cityName2;
    private String cityName3;
    private String tel;
    private String fax;
    private String mail;
    private String remarks1;
    private String remarks2;
    private String remarks3;
    private int unitPriceFractionDiv;
    private int priceFractionDiv;
	private String priceRank;
    private double retailPriceRate;
    private int taxDiv;
    private int deleteFlg;
    private int taxCalcDiv;
    private int taxFractionDigitDiv;
    private int taxFractionDiv;
    private String parentUserCd;
    private String billingDestinationCd;
    private String cutoffDateGrp1;
    private String recoveryMonth1;
    private String recoveryDay1;

    @FormProperty
    public String getUserCd() {
        return userCd;
    }

    public String getUserCategory1Cd() {
        return userCategory1Cd;
    }

    public String getUserCategory2Cd() {
        return userCategory2Cd;
    }

    public String getUserCategory3Cd() {
        return userCategory3Cd;
    }

    @FormProperty
    public String getUserName() {
        return userName1 + userName2;
    }

    public String getUserName1() {
        return userName1;
    }

    public String getUserName2() {
        return userName2;
    }

    public String getUserNameKana() {
        return userNameKana;
    }

    public String getBossName() {
        return bossName;
    }

    public String getZip() {
        return zip;
    }

    public String getCityName1() {
        return cityName1;
    }

    public String getCityName2() {
        return cityName2;
    }

    public String getCityName3() {
        return cityName3;
    }

    public String getTel() {
        return tel;
    }

    public String getFax() {
        return fax;
    }

    public String getMail() {
        return mail;
    }

    public String getRemarks1() {
        return remarks1;
    }

    public String getRemarks2() {
        return remarks2;
    }

    public String getRemarks3() {
        return remarks3;
    }

    public int getUnitPriceFractionDiv() {
        return unitPriceFractionDiv;
    }

    public int getPriceFractionDiv() {
        return priceFractionDiv;
    }

	public String getPriceRank() {
        return priceRank;
    }

    public double getRetailPriceRate() {
        return retailPriceRate;
    }

    public int getTaxDiv() {
        return taxDiv;
    }

    public int getDeleteFlg() {
        return deleteFlg;
    }

    public int getTaxCalcDiv() {
        return taxCalcDiv;
    }

    public int getTaxFractionDigitDiv() {
        return taxFractionDigitDiv;
    }

    public int getTaxFractionDiv() {
        return taxFractionDiv;
    }

    public String getParentUserCd() {
        return parentUserCd;
    }

    public String getBillingDestinationCd() {
        return billingDestinationCd;
    }

    public String getCutoffDateGrp1() {
        return cutoffDateGrp1;
    }

    public String getRecoveryMonth1() {
        return recoveryMonth1;
    }

    public String getRecoveryDay1() {
        return recoveryDay1;
    }

    public static User valueOf(Map<String, Object> map) {
        if (map == null) {
            return null;
        }

        User user = new User();

        user.userCd = StringUtil.defaultString(map.get("user_cd"), "");
        user.userName1 = StringUtil.defaultString(map.get("user_name1"), "");
        user.userName2 = StringUtil.defaultString(map.get("user_name2"), "");
        user.userCategory1Cd = StringUtil.defaultString(map.get("user_category1_cd"), "");
        user.userCategory2Cd = StringUtil.defaultString(map.get("user_category2_cd"), "");
        user.userCategory3Cd = StringUtil.defaultString(map.get("user_category3_cd"), "");
        user.bossName = StringUtil.defaultString(map.get("boss_name"), "");
        user.zip = StringUtil.defaultString(map.get("zip"), "");
        user.cityName1 = StringUtil.defaultString(map.get("city_name1"), "");
        user.cityName2 = StringUtil.defaultString(map.get("city_name2"), "");
        user.cityName3 = StringUtil.defaultString(map.get("city_name3"), "");
        user.tel = StringUtil.defaultString(map.get("tel"), "");
        user.fax = StringUtil.defaultString(map.get("fax"), "");
        user.remarks1 = StringUtil.defaultString(map.get("remarks1"), "");
        user.remarks2 = StringUtil.defaultString(map.get("remarks2"), "");
        user.remarks3 = StringUtil.defaultString(map.get("remarks3"), "");

        if (map.get("unit_price_fraction_div") != null) {
            user.unitPriceFractionDiv = StringUtil.toInteger(String.valueOf(map.get("unit_price_fraction_div")), 0);
        }
        if (map.get("price_fraction_div") != null) {
            user.priceFractionDiv = StringUtil.toInteger(String.valueOf(map.get("price_fraction_div")), 0);
        }
        if (map.get("price_rank") != null) {
			user.priceRank = String.valueOf(map.get("price_rank"));
        }
        if (map.get("retail_price_rate") != null) {
            user.retailPriceRate = StringUtil.toDouble(String.valueOf(map.get("retail_price_rate")), 100.0);
        }
        if (map.get("tax_div") != null) {
            user.taxDiv = StringUtil.toInteger(String.valueOf(map.get("tax_div")), 1);
        }
        if (map.get("delete_flg") != null) {
            user.deleteFlg = StringUtil.toInteger(String.valueOf(map.get("delete_flg")), 0);
        }
        if (map.get("tax_calc_div") != null) {
            user.taxCalcDiv = StringUtil.toInteger(String.valueOf(map.get("tax_calc_div")), 1);
        }
        if (map.get("tax_fraction_digit_div") != null) {
            user.taxFractionDigitDiv = StringUtil.toInteger(String.valueOf(map.get("tax_fraction_digit_div")), 0);
        }
        if (map.get("tax_fraction_div") != null) {
            user.taxFractionDiv = StringUtil.toInteger(String.valueOf(map.get("tax_fraction_div")), 0);
        }
        user.parentUserCd = StringUtil.defaultString(map.get("parent_user_cd"), "");
        user.billingDestinationCd = StringUtil.defaultString(map.get("billing_destionation_cd"), "");
        user.cutoffDateGrp1 = StringUtil.defaultString("cufoff_date_grp1", "");
        user.recoveryMonth1 = StringUtil.defaultString("recovery_month1", "");
        user.recoveryDay1 = StringUtil.defaultString("recovery_day1", "");

        return user;
    }

    /**
     * ユーザー情報をデータベースから再取得する
     * @param dto
     * @param userCd
     * @return
     */
    public static User getUser(ActionDto dto, String userCd) {
        return valueOf(getUserMap(dto, userCd));
    }

    /**
     * ユーザー情報をデータベースから再取得する
     * @param dto
     * @param userCd
     * @return
     */
    public static Map<String, Object> getUserMap(ActionDto dto, String userCd) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("tbu.val ");
        query.append("FROM entity_data tbu ");
        query.append("WHERE tbu.tenant_id = {#tenant_id, text, action#} ");
        query.append("AND tbu.edit_table_cd = 'user' ");
        query.append("AND tbu.val->>'user_cd' = {#user_cd, text, param#} ");
        query.append("AND tbu.val->>'delete_flg' = {#0, text#} ");

        Map<String, Object> params = new HashMap<>();
        params.put("user_cd", userCd);

        JSONDomaSQLQueryBuilder queryBuilder = new JSONDomaSQLQueryBuilder();
        Map<String, Object> userMap = queryBuilder.getFirstResult(query.toString(),
                params, dto);
        return userMap;
    }

}
