package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;

public class TmpOrderDetail implements DomainObject {

    private String tmpOrderNo;
    private Integer recordNo;
    private Integer cartId;
    private String userCd;
    private String itemCd;
    private String itemName1;
    private String itemName2;
    private BigDecimal quantityPerCase;
    private BigDecimal orderCaseQuantity;
    private BigDecimal orderQuantity;
    private BigDecimal retailPrice;
    private BigDecimal wholesalePrice;
    private Integer orderCampaignCd;

    public TmpOrderDetail() {

    }

    public TmpOrderDetail(String tmpOrderNo, Integer recordNo, Map<String, Object> detail, Item item, User user) {
        this.tmpOrderNo = tmpOrderNo;
        this.recordNo = recordNo;
        this.userCd = user.getUserCd();
        this.itemCd = item.getItemCd();
        this.itemName1 = item.getItemName1();
        this.itemName2 = item.getItemName2();
        if (detail.get("cart_id") != null) {
            this.cartId =  Integer.valueOf(String.valueOf(detail.get("cart_id")));
        }
        this.quantityPerCase = item.getQuantityPerCase();
        this.orderCaseQuantity = new BigDecimal(String.valueOf(detail.get("order_case_quantity")));
        this.orderQuantity = new BigDecimal(String.valueOf(detail.get("order_quantity")));
        this.wholesalePrice = new BigDecimal(String.valueOf(detail.get("wholesale_price")));
        if (detail.get("retail_price") != null) {
            this.retailPrice = new BigDecimal(String.valueOf(detail.get("retail_price")));
        }
    }

    @FormProperty
    public String getTmpOrderNo() {
        return tmpOrderNo;
    }
    public void setTmpOrderNo(String tmpOrderNo) {
        this.tmpOrderNo = tmpOrderNo;
    }

    @FormProperty
    public Integer getRecordNo() {
        return recordNo;
    }
    public void setRecordNo(Integer recordNo) {
        this.recordNo = recordNo;
    }

    @FormProperty
    public Integer getCartId() {
        return cartId;
    }
    public void setCartId(Integer cartId) {
        this.cartId = cartId;
    }

    @FormProperty
    public String getUserCd() {
        return userCd;
    }
    public void setUserCd(String userCd) {
        this.userCd = userCd;
    }

    @FormProperty
    public String getItemCd() {
        return itemCd;
    }
    public void setItemCd(String itemCd) {
        this.itemCd = itemCd;
    }

    @FormProperty
    public String getItemName1() {
        return itemName1;
    }
    public void setItemName1(String itemName1) {
        this.itemName1 = itemName1;
    }

    @FormProperty
    public String getItemName2() {
        return itemName2;
    }
    public void setItemName2(String itemName2) {
        this.itemName2 = itemName2;
    }

    @FormProperty
    public BigDecimal getQuantityPerCase() {
        return quantityPerCase;
    }
    public void setQuantityPerCase(BigDecimal quantityPerCase) {
        this.quantityPerCase = quantityPerCase;
    }

    @FormProperty
    public BigDecimal getOrderCaseQuantity() {
        return orderCaseQuantity;
    }
    public void setOrderCaseQuantity(BigDecimal orderCaseQuantity) {
        this.orderCaseQuantity = orderCaseQuantity;
    }

    @FormProperty
    public BigDecimal getOrderQuantity() {
        return orderQuantity;
    }
    public void setOrderQuantity(BigDecimal orderQuantity) {
        this.orderQuantity = orderQuantity;
    }

    @FormProperty
    public BigDecimal getRetailPrice() {
        return retailPrice;
    }
    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

    @FormProperty
    public BigDecimal getWholesalePrice() {
        return wholesalePrice;
    }
    public void setWholesalePrice(BigDecimal wholesalePrice) {
        this.wholesalePrice = wholesalePrice;
    }

    @FormProperty
    public Integer getOrderCampaignCd() {
        return orderCampaignCd;
    }
    public void setOrderCampaignCd(Integer orderCampaignCd) {
        this.orderCampaignCd = orderCampaignCd;
    }

    public static TmpOrderDetail valueOf(Map<String, Object> map) {
        TmpOrderDetail detail = new TmpOrderDetail();

        detail.tmpOrderNo = String.valueOf(map.get("tmp_order_no"));
        detail.recordNo = StringUtil.toInteger(String.valueOf(map.get("record_no")), 1);
        detail.cartId = StringUtil.toInteger(String.valueOf(map.get("cart_id")), 1);

        return detail;
    }

}
