package jp.ill.photon.model;

import java.util.Map;

import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.CheckUtil;
import jp.ill.photon.util.StringUtil;

public class TmpOrder implements DomainObject {

	private String tmpOrderNo;
	private String wishingShipmentDate;
	private String userCd;
	private String userDeliveryCd;
	private String userDeliveryName1;
	private String userDeliveryName2;
	private String zip;
	private String cityName1;
	private String cityName2;
	private String cityName3;
	private String tel;
	private String fax;
	private String userOrderNo;
	private String remarks;
	private String estimateNo;
	private String paymentCd;
	private String paymentName;
	private String conveniencePaymentCd;
	private String areaName;

	private String deliveryFeeCd;
	private String creditPaymentMethodCd;
	private String creditNumberOfPaymentCd;

	public TmpOrder() {

	}

	public TmpOrder(String tmpOrderNo, Order order, User user,
			Delivery delivery) {
		this.tmpOrderNo = tmpOrderNo;
		this.wishingShipmentDate = order.getWishingShipmentDate();
		this.userCd = user.getUserCd();
		this.userDeliveryCd = CheckUtil.isEmpty(delivery.getUserDeliveryCd())
				? null : delivery.getUserDeliveryCd();
		this.userDeliveryName1 = StringUtil
				.defaultString(delivery.getUserDeliveryName1(), "");
		this.userDeliveryName2 = StringUtil
				.defaultString(delivery.getUserDeliveryName2(), "");
		this.zip = StringUtil.defaultString(delivery.getZip(), "");
		this.cityName1 = StringUtil.defaultString(delivery.getCityName1(), "");
		this.cityName2 = StringUtil.defaultString(delivery.getCityName2(), "");
		this.cityName3 = StringUtil.defaultString(delivery.getCityName3(), "");
		this.tel = StringUtil.defaultString(delivery.getTel(), "");
		this.fax = StringUtil.defaultString(delivery.getFax(), "");
		this.userOrderNo = order.getUserOrderNo();
		this.remarks = order.getRemarks();
		this.areaName = order.getAreaName();
		this.estimateNo = order.getEstimateNo();
		this.deliveryFeeCd = order.getDeliveryFeeCd();
		this.paymentName = order.getPaymentName();

		this.paymentCd = order.getPaymentCd();
		this.conveniencePaymentCd = order.getConveniencePaymentCd();
		this.creditPaymentMethodCd = order.getCreditPaymentMethodCd();
		this.creditNumberOfPaymentCd = order.getCreditNumberOfPaymentCd();
	}

	@FormProperty
	public String getPaymentName() {
		return paymentName;
	}

	public void setPaymentName(String paymentName) {
		this.paymentName = paymentName;
	}

	@FormProperty
	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	@FormProperty
	public String getTmpOrderNo() {
		return tmpOrderNo;
	}

	public void setTmpOrderNo(String tmpOrderNo) {
		this.tmpOrderNo = tmpOrderNo;
	}

	@FormProperty
	public String getWishingShipmentDate() {
		return wishingShipmentDate;
	}

	public void setWishingShipmentDate(String wishingShipmentDate) {
		this.wishingShipmentDate = wishingShipmentDate;
	}

	@FormProperty
	public String getUserCd() {
		return userCd;
	}

	public void setUserCd(String userCd) {
		this.userCd = userCd;
	}

	@FormProperty
	public String getUserDeliveryCd() {
		return userDeliveryCd;
	}

	public void setUserDeliveryCd(String userDeliveryCd) {
		this.userDeliveryCd = userDeliveryCd;
	}

	@FormProperty
	public String getUserDeliveryName1() {
		return userDeliveryName1;
	}

	public void setUserDeliveryName1(String userDeliveryName1) {
		this.userDeliveryName1 = userDeliveryName1;
	}

	@FormProperty
	public String getUserDeliveryName2() {
		return userDeliveryName2;
	}

	public void setUserDeliveryName2(String userDeliveryName2) {
		this.userDeliveryName2 = userDeliveryName2;
	}

	@FormProperty
	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	@FormProperty
	public String getCityName_1() {
		return cityName1;
	}

	// @FormProperty
	public String getCityName1() {
		return cityName1;
	}

	public void setCityName1(String cityName1) {
		this.cityName1 = cityName1;
	}

	@FormProperty
	public String getCityName_2() {
		return cityName2;
	}

	// @FormProperty
	public String getCityName2() {
		return cityName2;
	}

	public void setCityName2(String cityName2) {
		this.cityName2 = cityName2;
	}

	@FormProperty
	public String getCityName_3() {
		return cityName3;
	}

	// @FormProperty
	public String getCityName3() {
		return cityName3;
	}

	public void setCityName3(String cityName3) {
		this.cityName3 = cityName3;
	}

	@FormProperty
	public String getTel() {
		return tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	@FormProperty
	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}

	@FormProperty
	public String getUserOrderNo() {
		return userOrderNo;
	}

	public void setUserOrderNo(String userOrderNo) {
		this.userOrderNo = userOrderNo;
	}

	@FormProperty
	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	@FormProperty
	public String getEstimateNo() {
		return estimateNo;
	}

	public void setEstimateNo(String estimateNo) {
		this.estimateNo = estimateNo;
	}

	@FormProperty
	public String getPaymentCd() {
		return paymentCd;
	}

	public void setPaymentCd(String paymentCd) {
		this.paymentCd = paymentCd;
	}

	public String getConveniencePaymentCd() {
		return conveniencePaymentCd;
	}

	public void setConveniencePaymentCd(String conveniencePaymentCd) {
		this.conveniencePaymentCd = conveniencePaymentCd;
	}

	public String getDeliveryFeeCd() {
		return deliveryFeeCd;
	}

	public void setDeliveryFeeCd(String deliveryFeeCd) {
		this.deliveryFeeCd = deliveryFeeCd;
	}

	public String getCreditPaymentMethodCd() {
		return creditPaymentMethodCd;
	}

	public void setCreditPaymentMethodCd(String creditPaymentMethodCd) {
		this.creditPaymentMethodCd = creditPaymentMethodCd;
	}

	public String getCreditNumberOfPaymentCd() {
		return creditNumberOfPaymentCd;
	}

	public void setCreditNumberOfPaymentCd(String creditNumberOfPaymentCd) {
		this.creditNumberOfPaymentCd = creditNumberOfPaymentCd;
	}

	public static TmpOrder valueOf(Map<String, Object> map) {

		TmpOrder order = new TmpOrder();

		order.tmpOrderNo = String.valueOf(map.get("tmp_order_no"));
		if (map.get("wishing_shipment_date") != null) {
			order.wishingShipmentDate = String
					.valueOf(map.get("wishing_shipment_date"));
		}

		order.userCd = String.valueOf(map.get("user_cd"));

		if (map.get("user_delivery_cd") != null) {
			order.userDeliveryCd = String.valueOf(map.get("user_delivery_cd"));
		}
		if (map.get("user_delivery_name1") != null) {
			order.userDeliveryName1 = String
					.valueOf(map.get("user_delivery_name1"));
		}
		if (map.get("user_delivery_name2") != null) {
			order.userDeliveryName2 = String
					.valueOf(map.get("user_delivery_name2"));
		}
		if (map.get("zip") != null) {
			order.zip = String.valueOf(map.get("zip"));
		}
		if (map.get("city_name1") != null) {
			order.cityName1 = String.valueOf(map.get("city_name1"));
		}
		if (map.get("city_name2") != null) {
			order.cityName2 = String.valueOf(map.get("city_name2"));
		}
		if (map.get("city_name3") != null) {
			order.cityName3 = String.valueOf(map.get("city_name3"));
		}
		if (map.get("tel") != null) {
			order.tel = String.valueOf(map.get("tel"));
		}
		if (map.get("fax") != null) {
			order.fax = String.valueOf(map.get("fax"));
		}
		if (map.get("user_order_no") != null) {
			order.userOrderNo = String.valueOf(map.get("user_order_no"));
		}
		if (map.get("remarks") != null) {
			order.remarks = String.valueOf(map.get("remarks"));
		}
		if (map.get("payment_cd") != null) {
			order.paymentCd = String.valueOf(map.get("payment_cd"));
		}
		if (map.get("convenience_payment_cd") != null) {
			order.conveniencePaymentCd = String
					.valueOf(map.get("convenience_payment_cd"));
		}
		if (map.get("credit_payment_method_cd") != null) {
			order.creditPaymentMethodCd = String
					.valueOf(map.get("credit_payment_method_cd"));
		}
		if (map.get("credit_number_of_payment_cd") != null) {
			order.creditNumberOfPaymentCd = String
					.valueOf(map.get("credit_number_of_payment_cd"));
		}
		if (map.get("area_name") != null) {
			order.areaName = String.valueOf(map.get("area_name"));
		}
		if (map.get("delivery_fee_cd") != null) {
			order.deliveryFeeCd = String.valueOf(map.get("delivery_fee_cd"));
		}
		if (map.get("payment_name") != null) {
			order.paymentName = String.valueOf(map.get("payment_name"));
		}

		return order;
	}

}
