package jp.ill.photon.model;

import java.util.Map;

import jp.ill.photon.util.StringUtil;

public class TaxSetting {

    private int taxDivCode;
    private Double taxRate;
    private String applyStartDate;
    private String applyEndDate;

    public int getTaxDivCode() {
        return taxDivCode;
    }
    public void setTaxDivCode(int taxDivCode) {
        this.taxDivCode = taxDivCode;
    }
    public Double getTaxRate() {
        return taxRate;
    }
    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }
    public String getApplyStartDate() {
        return applyStartDate;
    }
    public void setApplyStartDate(String applyStartDate) {
        this.applyStartDate = applyStartDate;
    }
    public String getApplyEndDate() {
        return applyEndDate;
    }
    public void setApplyEndDate(String applyEndDate) {
        this.applyEndDate = applyEndDate;
    }

    public static TaxSetting valueOf(Map<String, Object> map) {
        TaxSetting setting = new TaxSetting();

        setting.taxDivCode = StringUtil.toInteger(String.valueOf(map.get("tax_div_code")), 1);
        setting.taxRate = StringUtil.toDouble(String.valueOf(map.get("tax_rate")), 0.0);
        setting.applyStartDate = String.valueOf(map.get("apply_start_date"));
        setting.applyEndDate = String.valueOf(map.get("apply_end_date"));

        return setting;
    }



}
