package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.LinkedHashMap;

import jp.ill.photon.util.AoUtil.FractionDiv;
import jp.ill.photon.util.CheckUtil;

public class Tax {

    // 消費税計算処理
    public static String taxCalcPrice( String price,
                                String tax,
                                String div,
                                String fractionDiv,
                                String fractionDigit) {
        // 価格フォーマット
        price = price.replace(",", "");
        if (!CheckUtil.isDouble(price)) {
            price = "0";
        }
        price = price.trim();

        Integer digit = 0;
        // 端数処理桁数判定
        // 円未満
        if (TaxFractionDigitsDiv.ONE_YEN
                .equals(fractionDigit)) {
            digit = 0;
        }
        // 十円未満
        else if (TaxFractionDigitsDiv.TEN_YEN
                .equals(fractionDigit)) {
            digit = -1;
        }
        // 百円未満
        else if (TaxFractionDigitsDiv.HUNDRED_YEN
                .equals(fractionDigit)) {
            digit = -2;
        }

        BigDecimal bdValue = new BigDecimal(price);
        BigDecimal bdValue2 = new BigDecimal(tax);
        BigDecimal bdValue3 = bdValue2.add(new BigDecimal("1.00"));
        BigDecimal bdResult = null;

        // 税抜(外税計算)
        if (TaxDiv.EXCLUDING.equals(div)) {
            // 切り捨て
            if (FractionDiv.DOWN.equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).setScale(digit,
                        BigDecimal.ROUND_DOWN);
            }
            // 四捨五入
            else if (FractionDiv.HALF_UP
                    .equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).setScale(digit,
                        BigDecimal.ROUND_HALF_UP);
            }
            // 切り上げ
            else if (FractionDiv.UP.equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).setScale(digit,
                        BigDecimal.ROUND_UP);
            }
        }

        // 税込(内税計算)
        else if (TaxDiv.INCLUDING.equals(div)) {
            // 切り捨て
            if (FractionDiv.DOWN.equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).divide(bdValue3, digit,
                        BigDecimal.ROUND_DOWN);
            }
            // 四捨五入
            else if (FractionDiv.HALF_UP
                    .equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).divide(bdValue3, digit,
                        BigDecimal.ROUND_HALF_UP);
            }
            // 切り上げ
            else if (FractionDiv.UP.equals(fractionDiv)) {
                bdResult = bdValue.multiply(bdValue2).divide(bdValue3, digit,
                        BigDecimal.ROUND_UP);
            }
        }

        return bdResult != null ? bdResult.toString() : null;
    }



    // Aladdin-EC ファッション版機能マージ EDIT-S
    /** 消費税区分 */
    public static class TaxDiv {
        /** 税抜 */
        public static final String EXCLUDING = "1";
        /** 税込 */
        public static final String INCLUDING = "2";
        /** マップ */
        public static final LinkedHashMap<String, String> TAX_DIV_MAP = new LinkedHashMap<String, String>();
        static {
            TAX_DIV_MAP.put(EXCLUDING, "税抜");
            TAX_DIV_MAP.put(INCLUDING, "税込");
        }
    }


    /** 消費税端数処理桁数区分 */
    public static class TaxFractionDigitsDiv {
        /** 円未満 */
        public static final String ONE_YEN = "0";
        /** 十円未満 */
        public static final String TEN_YEN = "1";
        /** 百円未満 */
        public static final String HUNDRED_YEN = "2";
        /** マップ */
        public static final LinkedHashMap<String, String> TAX_FRACTION_DIGITS_DIV_MAP = new LinkedHashMap<String, String>();
        static {
            TAX_FRACTION_DIGITS_DIV_MAP.put(ONE_YEN, "円未満");
            TAX_FRACTION_DIGITS_DIV_MAP.put(TEN_YEN, "十円未満");
            TAX_FRACTION_DIGITS_DIV_MAP.put(HUNDRED_YEN, "百円未満");
        }
    }

    /** 消費税算出処理区分 */
    public static class TaxCalcDiv {
        /** 伝票明細 */
        public static final String ORDER_DETAIL = "1";
        /** 伝票合計 */
        public static final String ORDER_TOTAL = "2";
        /** 請求合計 */
        public static final String CLAIM_TOTAL = "3";
        /** 対象外 */
        public static final String OUT_OF_TARGET = "9";
        /** マップ */
        public static final LinkedHashMap<String, String> TAX_CALC_DIV_MAP = new LinkedHashMap<String, String>();
        static {
            TAX_CALC_DIV_MAP.put(ORDER_DETAIL, "伝票明細");
            TAX_CALC_DIV_MAP.put(ORDER_TOTAL, "伝票合計");
            TAX_CALC_DIV_MAP.put(CLAIM_TOTAL, "請求合計");
            TAX_CALC_DIV_MAP.put(OUT_OF_TARGET, "対象外");
        }
    }

	/** 非課税区分 */
	public static class TaxExemptDiv {
		/** 課税 */
		public static final String OFF = "0";
		/** 非課税 */
		public static final String ON = "1";
	}

}
