package jp.ill.photon.model;

import java.util.LinkedHashMap;
import java.util.Map;

public class SystemSetting {

	/** データ */
	private Map<String, Object> systemSetting;

	/** ON/OFF */
	public static class OnOff {
		/** ON */
		public static final String ON = "1";
		/** OFF */
		public static final String OFF = "0";
		/** ON(文字列) */
		public static final String ON_STR = "ON";
		/** OFF(文字列) */
		public static final String OFF_STR = "OFF";
		/** マップ */
		public static final LinkedHashMap<String, String> ON_OFF_MAP = new LinkedHashMap<String, String>();
		static {
			ON_OFF_MAP.put(ON, ON_STR);
			ON_OFF_MAP.put(OFF, OFF_STR);
		}
		/** マップ */
		public static final LinkedHashMap<String, String> ON_OFF_REVERSE_MAP = new LinkedHashMap<String, String>();
		static {
			ON_OFF_MAP.put(OFF, OFF_STR);
			ON_OFF_MAP.put(ON, ON_STR);
		}
	}

	/** ケース数区分 */
	public static class CaseNumDiv extends OnOff {
	}

	/** 展示会受注モード */
	public static class ExhibitFlg extends OnOff {
		public static final LinkedHashMap<String, String> EXHIBIT_FLG_MAP = ON_OFF_REVERSE_MAP;
	}

	/** 表示フラグ */
	public static class DispFlg {

		/** 非表示 */
		public static final String NO = OnOff.OFF;
		/** 表示 */
		public static final String YES = OnOff.ON;
		/** 条件なし */
		public static final String NOT = "9";

		/** 表示 */
		public static final String DISP = "表示";
		/** 非表示 */
		public static final String NO_DISP = "非表示";
		/** 条件なし */
		public static final String NO_CONDITION = "条件なし";

		/** 表示フラグ名マップ */
		public static final LinkedHashMap<String, String> DISP_FLG_MAP = new LinkedHashMap<String, String>();
		static {
			DISP_FLG_MAP.put(YES, DISP);
			DISP_FLG_MAP.put(NO, NO_DISP);
		}
		/** 表示フラグ名マップ(非表示が先) */
		public static final LinkedHashMap<String, String> DISP_FLG_REVERSE_MAP = new LinkedHashMap<String, String>();
		static {
			DISP_FLG_REVERSE_MAP.put(NO, NO_DISP);
			DISP_FLG_REVERSE_MAP.put(YES, DISP);
		}

		/** 表示フラグ条件マップ */
		public static final LinkedHashMap<String, String> DISP_FLG_CONDITION_MAP = new LinkedHashMap<String, String>();
		static {
			DISP_FLG_CONDITION_MAP.put(NOT, NO_CONDITION);
			DISP_FLG_CONDITION_MAP.put(YES, DISP);
			DISP_FLG_CONDITION_MAP.put(NO, NO_DISP);
		}

	}

	/** サブ商品分類表示フラグ */
	public static class ItemCategoryDispFlg extends DispFlg {
	}

	/** 未ログイン時の在庫表示数フラグ */
	public static class NoLoginStockDispFlg extends DispFlg {
		/** マップ */
		public static final LinkedHashMap<String, String> NO_LOGIN_STOCK_DISP_MAP = DISP_FLG_REVERSE_MAP;
	}

	/** カートボタン表示フラグ */
	public static class CartDispFlg extends DispFlg {
		/** マップ */
		public static final LinkedHashMap<String, String> CART_DISP_MAP = DISP_FLG_MAP;
		/** 表示フラグ条件マップ */
		public static final LinkedHashMap<String, String> CART_DISP_FLG_CONDITION_MAP = DISP_FLG_CONDITION_MAP;
	}

	/** 到着希望日表示フラグ */
	public static class WishingShipmentDateDispFlg extends DispFlg {
		/** マップ */
		public static final LinkedHashMap<String, String> WISHING_SHIPMENT_DATE_DISP_FLG_MAP = DISP_FLG_REVERSE_MAP;
	}

	/** 表示フラグ(AO) */
	public static class AoDispFlg extends DispFlg {
		/** マップ */
		public static final LinkedHashMap<String, String> AO_DISP_MAP = DISP_FLG_REVERSE_MAP;
	}

	/** 削除フラグ */
	public static class DeleteFlg {
		/** 未削除 */
		public static final String DELETE_FLG_OFF = OnOff.OFF;
		/** 削除済 */
		public static final String DELETE_FLG_ON = OnOff.ON;
		/** 削除フラグ名マップ */
		public static final LinkedHashMap<String, String> DELETE_MAP = new LinkedHashMap<String, String>();
		static {
			DELETE_MAP.put(DELETE_FLG_OFF, "未削除");
			DELETE_MAP.put(DELETE_FLG_ON, "削除済");
		}
	}

	/** 得意先別担当者_表示フラグ */
	public static class UserChargeDispFlg extends DeleteFlg {
	}

	/**
	 * システム設定情報からキーを指定して設定値を取得
     * @param key
	 * @return systemSetting
	 */
	@SuppressWarnings("rawtypes")
	public String get(String key) {
		if (systemSetting == null) {
			return null;
		}
		Map map = (Map)systemSetting.get(key);
		if (map == null) {
			return null;
		}
		Object note = map.get("note");
		return (note == null)? null: (String)note;
	}

	/**
	 * システム設定情報を設定
     * @param map
	 * @return システム設定情報
	 */
	public static SystemSetting valueOf(Map<String, Object> map) {
		SystemSetting setting = new SystemSetting();
		setting.systemSetting = map;
		return setting;
	}


}
