package jp.ill.photon.model;

import java.util.LinkedHashMap;
import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.util.StringUtil;

public class SmbcPayment {

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.payment_cd")
    private String paymentCd;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.shop_cd")
    private String shopCd;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.receipt_co_cd")
    private String receiptCoCd;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.base_cd")
    private String baseCd;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.shop_password")
    private String shopPassword;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.payment_limit_day")
    private Integer paymentLimitDay;

    @DefaultParamSetting(transferType = "param", transferVal = "smbc_payment.security_cd_input_div")
    private Integer securityCdInputDiv = 0;

    public String getPaymentCd() {
        return paymentCd;
    }

    public void setPaymentCd(String paymentCd) {
        this.paymentCd = paymentCd;
    }

    public String getShopCd() {
        return shopCd;
    }

    public void setShopCd(String shopCd) {
        this.shopCd = shopCd;
    }

    public String getReceiptCoCd() {
        return receiptCoCd;
    }

    public void setReceiptCoCd(String receiptCoCd) {
        this.receiptCoCd = receiptCoCd;
    }

    public String getBaseCd() {
        return baseCd;
    }

    public void setBaseCd(String baseCd) {
        this.baseCd = baseCd;
    }

    public String getShopPassword() {
        return shopPassword;
    }

    public void setShopPassword(String shopPassword) {
        this.shopPassword = shopPassword;
    }

    public Integer getPaymentLimitDay() {
        return paymentLimitDay;
    }

    public void setPaymentLimitDay(Integer paymentLimitDay) {
        this.paymentLimitDay = paymentLimitDay;
    }

    public Integer getSecurityCdInputDiv() {
        return securityCdInputDiv;
    }

    public void setSecurityCdInputDiv(Integer securityCdInputDiv) {
        this.securityCdInputDiv = securityCdInputDiv;
    }

    public static SmbcPayment valueOf(Map<String, Object> map) {
        SmbcPayment payment = new SmbcPayment();

        payment.paymentCd = String.valueOf(map.get("payment_cd"));
        payment.shopCd = String.valueOf(map.get("shop_cd"));
        payment.receiptCoCd = String.valueOf(map.get("receipt_co_cd"));
        payment.baseCd = String.valueOf(map.get("base_cd"));
        payment.shopPassword = String.valueOf(map.get("shop_password"));

        if (map.get("payment_limit_day") != null) {
            payment.paymentLimitDay = StringUtil.toInteger(String.valueOf(map.get("payment_limit_day")), 0);
        }
        if (map.get("security_cd_input_div") != null) {
            payment.securityCdInputDiv = StringUtil.toInteger(String.valueOf(map.get("security_cd_input_div")), 0);
        }

        return payment;
    }

    /** API連携設定 */
    public static class ApiLink {

        /** SMBCAPI接続先 */
        public static class ConnectSmbcApi {
            /** テスト環境 */
            public static final String TEST = "0";
            /** 本番環境 */
            public static final String PERFORMANCE = "1";
        }

        /** バージョン */
        public static class Version {
            /** PCサイトのすべての決済手段 */
            public static final String PC_SITE_ALL = "210";
        }

        /** 顧客メールアドレス区分 */
        public static class CustomerMailAddressDiv {
            /** PC */
            public static final String PC = "0";
        }

        /** 実行結果 */
        public static class Result {
            /** 実行結果_正常 */
            public static final String SUCCESS = "000000";
            /** ３Ｄセキュア認証利用先(３Ｄセキュア認証前) */
            public static final String SUCCESS_3D = "000100";
        }

        /** 決済手段区分 */
        public static class AccountWay {

            /** コンビニ決済(受付番号)(EC2B側) */
            public static final String CONVENIENCE_STORE_RECEPTION_EC2B = "03";
            /** クレジット(EC2B側) */
            public static final String CREDIT_EC2B = "04";

            /** コンビニ決済(受付番号)(SMBC側) */
            public static final String CONVENIENCE_STORE_RECEPTION_SMBC = "03";
            /** クレジット(SMBC側) */
            public static final String CREDIT_SMBC = "05";

            /** EC2B側コード - SMBC側コード 関連マップ */
            public static final LinkedHashMap<String, String> ACCOUNT_WAY_MAP = new LinkedHashMap<String, String>();
            static {
                ACCOUNT_WAY_MAP.put(CONVENIENCE_STORE_RECEPTION_EC2B,
                        CONVENIENCE_STORE_RECEPTION_SMBC);
                ACCOUNT_WAY_MAP.put(CREDIT_EC2B, CREDIT_SMBC);
            }

        }

        /** 決済種類コード */
        public static class PaymentMethodCd {

            /** セブンイレブン(EC2B側) */
            public static final String SEVEN_ELEVEN_EC2B = "01";
            /** ローソン・ミニストップ(EC2B側) */
            public static final String LAWSON_EC2B = "02";
            /** セイコーマート(EC2B側) */
            public static final String SEIKO_MART_EC2B = "03";
            /** ファミリーマート(EC2B側) */
            public static final String FAMILY_MART_EC2B = "04";
            /** サークルK・サンクス(EC2B側) */
            public static final String CIRCLE_K_EC2B = "05";

            /** セブンイレブン(SMBC側) */
            public static final String SEVEN_ELEVEN_SMBC = "0301";
            /** ローソン・ミニストップ(SMBC側) */
            public static final String LAWSON_SMBC = "0302";
            /** セイコーマート(SMBC側) */
            public static final String SEIKO_MART_SMBC = "0303";
            /** ファミリーマート(SMBC側) */
            public static final String FAMILY_MART_SMBC = "0304";
            /** サークルK・サンクス(SMBC側) */
            public static final String CIRCLE_K_SMBC = "0305";

            /** EC2B側コード - SMBC側コード 関連マップ */
            public static final LinkedHashMap<String, String> PAYMENT_METHOD_CD_MAP = new LinkedHashMap<String, String>();
            static {
                PAYMENT_METHOD_CD_MAP.put(SEVEN_ELEVEN_EC2B,
                        SEVEN_ELEVEN_SMBC);
                PAYMENT_METHOD_CD_MAP.put(LAWSON_EC2B, LAWSON_SMBC);
                PAYMENT_METHOD_CD_MAP.put(SEIKO_MART_EC2B, SEIKO_MART_SMBC);
                PAYMENT_METHOD_CD_MAP.put(FAMILY_MART_EC2B,
                        FAMILY_MART_SMBC);
                PAYMENT_METHOD_CD_MAP.put(CIRCLE_K_EC2B, CIRCLE_K_SMBC);
            }
            /** EC2B側コード - 払い出し名 関連マップ */
            public static final LinkedHashMap<String, String[]> PAYOUT_NAME_MAP = new LinkedHashMap<String, String[]>();
            static {
                PAYOUT_NAME_MAP.put(SEVEN_ELEVEN_EC2B, new String[] {
                        "払込票番号", "払込票URL", "" });
                // Aladdin-EC ３次課題対応_7821 EDIT-S
                PAYOUT_NAME_MAP.put(LAWSON_EC2B, new String[] { "支払受付番号",
                        "", "" });
                PAYOUT_NAME_MAP.put(SEIKO_MART_EC2B, new String[] {
                        "支払受付番号", "", "" });
                // Aladdin-EC ３次課題対応_7821 EDIT-E
                PAYOUT_NAME_MAP.put(FAMILY_MART_EC2B, new String[] {
                        "企業コード", "注文番号", "" });
                PAYOUT_NAME_MAP.put(CIRCLE_K_EC2B, new String[] {
                        "オンライン決済番号", "", "" });
            }

        }

        /** 日時フォーマット */
        public static class DateTimeFormat {
            /** YYYYMMDD形式 */
            public static final String FORMAT_YYMMDD = "yyyyMMdd";
        }

        /** クレジット支払区分 */
        public static class CreditPayDiv {
            /** １回払い */
            public static final String CREDIT_PAYMENT_DIV_01 = "1";
            /** ２回払い */
            public static final String CREDIT_PAYMENT_DIV_02 = "2";
            /** 分割払い（３回） */
            public static final String CREDIT_PAYMENT_DIV_03 = "3";
            /** 分割払い（５回） */
            public static final String CREDIT_PAYMENT_DIV_05 = "5";
            /** 分割払い（６回） */
            public static final String CREDIT_PAYMENT_DIV_06 = "6";
            /** 分割払い（１０回） */
            public static final String CREDIT_PAYMENT_DIV_10 = "10";
            /** 分割払い（１２回） */
            public static final String CREDIT_PAYMENT_DIV_12 = "12";
            /** 分割払い（１５回） */
            public static final String CREDIT_PAYMENT_DIV_15 = "15";
            /** 分割払い（１８回） */
            public static final String CREDIT_PAYMENT_DIV_18 = "18";
            /** 分割払い（２０回） */
            public static final String CREDIT_PAYMENT_DIV_20 = "20";
            /** 分割払い（２４回） */
            public static final String CREDIT_PAYMENT_DIV_24 = "24";
            /** リボ払い */
            public static final String CREDIT_PAYMENT_DIV_80 = "80";
            /** ボーナス一括払い */
            public static final String CREDIT_PAYMENT_DIV_91 = "91";

            /** 一括払い(EC2B) */
            public static final String LUMP_SUM_PAYMENT_EC2B = "01";
            /** ボーナス払い(EC2B) */
            public static final String BONUS_PAYMENT_EC2B = "02";
            /** 分割払い(EC2B) */
            public static final String DEVIDED_PAYMENT_EC2B = "03";
            /** リボ払い(EC2B) */
            public static final String REVOLVING_PAYMENT_EC2B = "04";

            /** 2回(EC2B) */
            public static final String DEVIDED_PAYMENT_02_EC2B = "02";
            /** 3回(EC2B) */
            public static final String DEVIDED_PAYMENT_03_EC2B = "03";
            /** 5回(EC2B) */
            public static final String DEVIDED_PAYMENT_05_EC2B = "05";
            /** 6回(EC2B) */
            public static final String DEVIDED_PAYMENT_06_EC2B = "06";
            /** 10回(EC2B) */
            public static final String DEVIDED_PAYMENT_10_EC2B = "10";
            /** 12回(EC2B) */
            public static final String DEVIDED_PAYMENT_12_EC2B = "12";
            /** 15回(EC2B) */
            public static final String DEVIDED_PAYMENT_15_EC2B = "15";
            /** 18回(EC2B) */
            public static final String DEVIDED_PAYMENT_18_EC2B = "18";
            /** 20回(EC2B) */
            public static final String DEVIDED_PAYMENT_20_EC2B = "20";
            /** 24回(EC2B) */
            public static final String DEVIDED_PAYMENT_24_EC2B = "24";

            /** EC2B側コード - SMBC側コード 関連マップ(非分割支払) */
            public static final LinkedHashMap<String, String> CREDIT_PAY_DIV_NOT_DEVIDED_MAP = new LinkedHashMap<String, String>();
            static {
                CREDIT_PAY_DIV_NOT_DEVIDED_MAP.put(LUMP_SUM_PAYMENT_EC2B,
                        CREDIT_PAYMENT_DIV_01);
                CREDIT_PAY_DIV_NOT_DEVIDED_MAP.put(BONUS_PAYMENT_EC2B,
                        CREDIT_PAYMENT_DIV_91);
                CREDIT_PAY_DIV_NOT_DEVIDED_MAP.put(REVOLVING_PAYMENT_EC2B,
                        CREDIT_PAYMENT_DIV_80);
            }
            /** EC2B側コード - SMBC側コード 関連マップ(分割支払) */
            public static final LinkedHashMap<String, String> CREDIT_PAY_DIV_DEVIDED_MAP = new LinkedHashMap<String, String>();
            static {
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_02_EC2B,
                        CREDIT_PAYMENT_DIV_02);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_03_EC2B,
                        CREDIT_PAYMENT_DIV_03);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_05_EC2B,
                        CREDIT_PAYMENT_DIV_05);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_06_EC2B,
                        CREDIT_PAYMENT_DIV_06);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_10_EC2B,
                        CREDIT_PAYMENT_DIV_10);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_12_EC2B,
                        CREDIT_PAYMENT_DIV_12);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_15_EC2B,
                        CREDIT_PAYMENT_DIV_15);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_18_EC2B,
                        CREDIT_PAYMENT_DIV_18);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_20_EC2B,
                        CREDIT_PAYMENT_DIV_20);
                CREDIT_PAY_DIV_DEVIDED_MAP.put(DEVIDED_PAYMENT_24_EC2B,
                        CREDIT_PAYMENT_DIV_24);

            }

        }

        /** クレジット支払区分 */
        public static class PaymentWay {
            /** クレジット */
            public static final String CREDIT = "0501";
        }

        /** 項目長 */
        public static class Length {
            /** 顧客名 */
            public static final int USER_NAME = 60;
            /** 顧客カナ名 */
            public static final int USER_KANA = 60;
            /** 顧客住所1 */
            public static final int USER_CITY_1 = 50;
            /** 顧客住所2 */
            public static final int USER_CITY_2 = 50;
            /** 顧客住所3 */
            public static final int USER_CITY_3 = 50;
            /** 顧客住所4 */
            public static final int USER_CITY_4 = 50;
            /** 顧客住所5 */
            public static final int USER_CITY_5 = 50;
            /** 商品[N]の商品名 */
            public static final int ITEM_NAME = 100;
            /** 請求内容（漢字） */
            public static final int BILL_KANJI = 100;
            /** 請求内容（カナ） */
            public static final int BILL_KANA = 48;
        }

    }

}
