package jp.ill.photon.model;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 汎用検索用モデル。 「search_form.」で始まるモジュールパラメータを集め、マップとして使用可能にする。
 * 
 * @author h_tanaka
 *
 */
public class SearchForm {

	private Map<String, Object> paramMap;

	public static SearchForm valueOf(Map<String, Object> map) {
		SearchForm form = new SearchForm();
		form.setParamMap(map);
		return form;
	}

	public Map<String, Object> getParamMap() {
		if (paramMap == null) {
			paramMap = new LinkedHashMap<>();
		}
		return paramMap;
	}

	public void setParamMap(Map<String, Object> paramMap) {
		this.paramMap = paramMap;
	}
}
