package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.Map;

import jp.ill.photon.util.StringUtil;

public class PaymentWay {

    private String paymentCd;

    private String paymentMethodCd;

    private BigDecimal requestAmountMax;

    private Integer maturityFrom;

    private Integer maturityTo;

    public String getPaymentCd() {
        return paymentCd;
    }

    public void setPaymentCd(String paymentCd) {
        this.paymentCd = paymentCd;
    }

    public String getPaymentMethodCd() {
        return paymentMethodCd;
    }

    public void setPaymentMethodCd(String paymentMethodCd) {
        this.paymentMethodCd = paymentMethodCd;
    }

    public BigDecimal getRequestAmountMax() {
        return requestAmountMax;
    }

    public void setRequestAmountMax(BigDecimal requestAmountMax) {
        this.requestAmountMax = requestAmountMax;
    }

    public Integer getMaturityFrom() {
        return maturityFrom;
    }

    public void setMaturityFrom(Integer maturityFrom) {
        this.maturityFrom = maturityFrom;
    }

    public Integer getMaturityTo() {
        return maturityTo;
    }

    public void setMaturityTo(Integer maturityTo) {
        this.maturityTo = maturityTo;
    }

    public static PaymentWay valueOf(Map<String, Object> map) {
        PaymentWay payment = new PaymentWay();

        payment.paymentCd = String.valueOf(map.get("payment_cd"));
        payment.paymentMethodCd = String.valueOf(map.get("payment_method_cd"));
        payment.requestAmountMax = StringUtil.toBigDecimal(String.valueOf(map.get("request_amount_max")), new BigDecimal(0.0));
        payment.maturityFrom = StringUtil.toInteger(String.valueOf(map.get("maturity_from")), 0);
        payment.maturityTo = StringUtil.toInteger(String.valueOf(map.get("maturity_to")), 0);

        return payment;
    }

}
