package jp.ill.photon.model;

import java.util.Map;

import jp.ill.photon.annotation.DefaultParamSetting;
import jp.ill.photon.annotation.FormProperty;
import jp.ill.photon.util.StringUtil;

public class Payment implements DomainObject {

    @DefaultParamSetting(transferType = "param", transferVal = "payment.payment_cd")
    private String paymentCd;

    private String paymentName;

    @DefaultParamSetting(transferType = "param", transferVal = "payment.disp_flg")
    private Integer dispFlg;

    @DefaultParamSetting(transferType = "param", transferVal = "payment.description")
    private String description;

    @FormProperty
    public String getPaymentCd() {
        return paymentCd;
    }

    public void setPaymentCd(String paymentCd) {
        this.paymentCd = paymentCd;
    }

    @FormProperty
    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }

    @FormProperty
    public Integer getDispFlg() {
        return dispFlg;
    }

    public void setDispFlg(Integer dispFlg) {
        this.dispFlg = dispFlg;
    }

    @FormProperty
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Payment valueOf(Map<String, Object> map) {
        Payment payment = new Payment();

        payment.paymentCd = String.valueOf(map.get("payment_cd"));
        payment.paymentName = String.valueOf(map.get("payment_name"));
        if (String.valueOf(map.get("disp_flg")) != null) {
            payment.dispFlg = StringUtil.toInteger(String.valueOf(map.get("disp_flg")), 0);
        }
        payment.description = String.valueOf(map.get("description"));

        return payment;
    }

    /* Aladdin-EC 3rdリリース #7438 START */
    public static final int CREDIT_CARD_NO_DISP = 4;
    /* Aladdin-EC 3rdリリース #7438 END */
    public static final int CREDIT_CARD_LIMIT_MONTH = 2;
    public static final int CREDIT_CARD_LIMIT_YEAR = 2;
    public static final int CREDIT_SECURITY_CD = 4;
    public static final int CREDIT_CARD_NO = 16;

    /** 決済手段区分 */
    public static class AccountWayDiv {
        /** 掛売 */
        public static final String SELLING_ON_CREDIT = "00";
        /** 代金引換 */
        public static final String COD = "01";
        /** 銀行振込 */
        public static final String BANK_TRANSFER = "02";
        /** コンビニ決済(SMBC：受付番号方式) */
        public static final String CONVENIENCE_STORE_RECEPTION_SMBC = "03";
        /** クレジット(SMBC) */
        public static final String CREDIT_SMBC = "04";
    }

    public static class CreditPaymentMethod {
        /** クレジット */
        public static final String IKKATSU = "01";

        public static final String BUNKAtSU = "03";
    }

}
