package jp.ill.photon.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import jp.ill.photon.dao.JsonDataDao;
import jp.ill.photon.module.ModuleContext;
import jp.ill.photon.util.UtilTools;

public class OrderSummary {

    private String sumWholesalePrice = "0";
    private String totalQuantity = "0";
    private String subTotalRetail = "0";
    private String sumRetailPrice = "0";

    public String getSumWholesalePrice() {
        return sumWholesalePrice;
    }
    public String getTotalQuantity() {
        return totalQuantity;
    }
    public String getSubTotalRetail() {
        return subTotalRetail;
    }
    public String getSumRetailPrice() {
        return sumRetailPrice;
    }

    public Item sumOrderDetail(ModuleContext context, JsonDataDao dao, CartItem cart, String userCd, AoSetting aoSetting, List<CartItem> cartItems, Map<String, Item> items, Map<String, Object> userForm ) {
    	return sumOrderDetail(context, dao, cart, userCd, aoSetting, cartItems ,items, userForm, false);
    }

    // transactionの範囲内から呼ばれる前提
    public Item sumOrderDetail(ModuleContext context, JsonDataDao dao, CartItem cart, String userCd, AoSetting aoSetting, List<CartItem> cartItems, Map<String, Item> items, Map<String, Object> userForm, boolean isSpecialDetail ) {
        List<Map<String, Object>> itemMap = dao.getItemForOrder(context.getDto().getTenantId(), cart.getItemCd(), userCd);
        if (itemMap == null || itemMap.isEmpty()) {
            return null;
        }
        Item item = Item.valueOf(itemMap.get(0));

        if (cartItems != null) {
            cartItems.add(cart);
        }
        if (items != null) {
            items.put(item.getItemCd(), item);
        }

        // 合計金額、合計数量へ加算  TODO ootah:2.0では合計金額は見出しに持たない？
        sumWholesalePrice = UtilTools.addBigDecimal(sumWholesalePrice,  cart.getSubTotalPriceFormat(aoSetting, userForm).toString());

        // キャンペーン、手数料、送料は合計数量に含めない
        if (!isSpecialDetail) {
        	totalQuantity = UtilTools.addDouble(totalQuantity, cart.getOrderQuantity().toString());
        }

        subTotalRetail = cart.getRetailSalesPriceFormat(aoSetting, userForm).toString();
        sumRetailPrice = UtilTools.addBigDecimal(sumRetailPrice, subTotalRetail);

        return item;
    }

    public Item sumOrderDetail(ModuleContext context, JsonDataDao dao, Map<String, Object> detail, String userCd, AoSetting aoSetting, Map<String, Item> items, Map<String, Object> userForm, boolean isSpecialDetail ) {

        List<Map<String, Object>> itemMap = dao.getItemForOrder(context.getDto().getTenantId(), String.valueOf(detail.get("item_cd")), userCd);
        if (itemMap == null || itemMap.isEmpty()) {
            return null;
        }
        Item item = Item.valueOf(itemMap.get(0));

        if (items != null) {
            items.put(item.getItemCd(), item);
        }

        // 合計金額、合計数量へ加算  TODO ootah:2.0では合計金額は見出しに持たない？

        BigDecimal subTotalPrice = CartItem.getSubTotalPriceFormat(aoSetting, detail, userForm);
        sumWholesalePrice = UtilTools.addBigDecimal(sumWholesalePrice,  subTotalPrice.toString());

        // キャンペーン、手数料、送料は合計数量に含めない
        if (!isSpecialDetail) {
        	totalQuantity = UtilTools.addDouble(totalQuantity, detail.get("order_quantity").toString());
        }

        subTotalRetail = CartItem.getRetailSalesPriceFormat(aoSetting, detail, userForm).toString();
        sumRetailPrice = UtilTools.addBigDecimal(sumRetailPrice, subTotalRetail);

        return item;

    }

}
